/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class NullAuditExpression
extends AbstractAtomicExpression {
    private PropertyNameGetter propertyNameGetter;

    public NullAuditExpression(String alias, PropertyNameGetter propertyNameGetter) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
    }

    @Override
    protected void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(enversService, entityName, propertyName);
        if (relatedEntity == null) {
            parameters.addNullRestriction(alias, propertyName);
        } else {
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, null, alias, null, true);
        }
    }
}

