/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryRemove;

public class PooledConnectionFactoryDefinition
extends PersistentResourceDefinition {
    public static final ConnectionFactoryAttribute[] ATTRIBUTES = PooledConnectionFactoryDefinition.define(ConnectionFactoryAttributes.Pooled.ATTRIBUTES, ConnectionFactoryAttributes.Common.ATTRIBUTES);
    private final boolean deployed;
    public static final PooledConnectionFactoryDefinition INSTANCE = new PooledConnectionFactoryDefinition(false);
    public static final PooledConnectionFactoryDefinition DEPLOYMENT_INSTANCE = new PooledConnectionFactoryDefinition(true);

    private static ConnectionFactoryAttribute[] define(ConnectionFactoryAttribute[] specific, ConnectionFactoryAttribute ... common) {
        int size = common.length + specific.length;
        ConnectionFactoryAttribute[] result = new ConnectionFactoryAttribute[size];
        System.arraycopy(specific, 0, result, 0, specific.length);
        for (int i = 0; i < common.length; ++i) {
            ConnectionFactoryAttribute newAttr;
            AttributeDefinition copy;
            ConnectionFactoryAttribute attr = common[i];
            AttributeDefinition definition = attr.getDefinition();
            if (definition == ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS) {
                copy = PooledConnectionFactoryDefinition.copy(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, "reconnectAttempts", true);
            } else {
                copy = PooledConnectionFactoryDefinition.copy(definition, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, attr.getPropertyName(), attr.isResourceAdapterProperty(), attr.getConfigType());
            }
            result[specific.length + i] = newAttr;
        }
        return result;
    }

    private static AttributeDefinition copy(AttributeDefinition attribute, AttributeAccess.Flag flag) {
        Object builder = attribute instanceof SimpleListAttributeDefinition ? new SimpleListAttributeDefinition.Builder((SimpleListAttributeDefinition)attribute) : (attribute instanceof SimpleMapAttributeDefinition ? new SimpleMapAttributeDefinition.Builder((SimpleMapAttributeDefinition)attribute) : (attribute instanceof PrimitiveListAttributeDefinition ? new PrimitiveListAttributeDefinition.Builder((PrimitiveListAttributeDefinition)attribute) : new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)attribute)));
        builder.setFlags(new AttributeAccess.Flag[]{flag});
        return builder.build();
    }

    public static Map<String, ConnectionFactoryAttribute> getAttributesMap() {
        HashMap<String, ConnectionFactoryAttribute> attrs = new HashMap<String, ConnectionFactoryAttribute>(ATTRIBUTES.length);
        for (ConnectionFactoryAttribute attribute : ATTRIBUTES) {
            attrs.put(attribute.getDefinition().getName(), attribute);
        }
        return attrs;
    }

    public PooledConnectionFactoryDefinition(boolean deployed) {
        super(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("pooled-connection-factory"), (OperationStepHandler)PooledConnectionFactoryAdd.INSTANCE, (OperationStepHandler)PooledConnectionFactoryRemove.INSTANCE);
        this.deployed = deployed;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES));
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        AttributeDefinition[] definitions = ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES);
        ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(definitions);
        for (AttributeDefinition attr : definitions) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)PooledConnectionFactoryConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
        }
    }
}

