/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PolicyReader
implements ErrorHandler {
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private PolicyFinder finder;
    private DocumentBuilder builder;
    private Logger logger;

    public PolicyReader(PolicyFinder finder, Logger logger) {
        this(finder, logger, null);
    }

    public PolicyReader(PolicyFinder finder, Logger logger, File schemaFile) {
        this.logger = logger;
        this.finder = finder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        if (schemaFile == null) {
            factory.setValidating(false);
        } else {
            factory.setValidating(true);
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaFile);
        }
        try {
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalArgumentException("Filed to setup reader: " + pce.toString());
        }
    }

    public synchronized AbstractPolicy readPolicy(File file) throws ParsingException {
        try {
            return this.handleDocument(this.builder.parse(file));
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to read the file", ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("Failed to parse the file", saxe);
        }
    }

    public synchronized AbstractPolicy readPolicy(InputStream input) throws ParsingException {
        try {
            return this.handleDocument(this.builder.parse(input));
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to read the stream", ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("Failed to parse the stream", saxe);
        }
    }

    public synchronized AbstractPolicy readPolicy(URL url) throws ParsingException {
        try {
            return this.readPolicy(url.openStream());
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to resolve the URL: " + url.toString(), ioe);
        }
    }

    private AbstractPolicy handleDocument(Document doc) throws ParsingException {
        Element root = doc.getDocumentElement();
        String name = root.getTagName();
        if (name.equals("Policy")) {
            return Policy.getInstance(root);
        }
        if (name.equals("PolicySet")) {
            return PolicySet.getInstance(root, this.finder);
        }
        throw new ParsingException("Unknown root document type: " + name);
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning("Warning on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning("Error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("error parsing policy");
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning("Fatal error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("fatal error parsing policy");
    }
}

