/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StaxWriterUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSPolicyWriter;
import org.picketlink.identity.federation.core.wstrust.writers.WSSecurityWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.w3c.dom.Element;

public class WSTrustRequestWriter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final XMLStreamWriter writer;

    public WSTrustRequestWriter(OutputStream out) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter((OutputStream)out);
    }

    public WSTrustRequestWriter(Result result) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter((Result)result);
    }

    public WSTrustRequestWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(RequestSecurityTokenCollection requestTokenCollection) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestSecurityTokenCollection", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wst", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<RequestSecurityToken> tokenList = requestTokenCollection.getRequestSecurityTokens();
        if (tokenList == null) {
            throw logger.nullValueError("RST list is null");
        }
        for (RequestSecurityToken token : tokenList) {
            this.write(token);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(RequestSecurityToken requestToken) throws ProcessingException {
        RenewTargetType renewTarget;
        CancelTargetType cancelTarget;
        ValidateTargetType validateTarget;
        OnBehalfOfType onBehalfOf;
        UseKeyType useKeyType;
        URI computedKeyAlgorithm;
        EntropyType entropy;
        URI keyType;
        long keySize;
        AppliesTo appliesTo;
        EndpointReferenceType endpoint;
        URI tokenType;
        URI requestType;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestSecurityToken", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wst", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String context = requestToken.getContext();
        if (StringUtil.isNotNull((String)context)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Context", (String)context);
        }
        if ((requestType = requestToken.getRequestType()) != null) {
            this.writeRequestType(this.writer, requestType);
        }
        if ((tokenType = requestToken.getTokenType()) != null) {
            this.writeTokenType(this.writer, tokenType);
        }
        if ((endpoint = requestToken.getIssuer()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Issuer", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsa", (String)"Address", (String)"http://www.w3.org/2005/08/addressing");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)endpoint.getAddress().getValue());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (requestToken.getLifetime() != null) {
            Lifetime lifetime = requestToken.getLifetime();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Lifetime", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeLifetime(lifetime.getCreated(), lifetime.getExpires());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((appliesTo = requestToken.getAppliesTo()) != null) {
            WSPolicyWriter wsPolicyWriter = new WSPolicyWriter(this.writer);
            wsPolicyWriter.write(appliesTo);
        }
        if ((keySize = requestToken.getKeySize()) != 0L) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"KeySize", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)Long.toString(keySize));
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((keyType = requestToken.getKeyType()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"KeyType", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)keyType.toString());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((entropy = requestToken.getEntropy()) != null) {
            this.writeEntropyType(entropy);
        }
        if ((computedKeyAlgorithm = requestToken.getComputedKeyAlgorithm()) != null) {
            this.writeComputedKeyAlgorithm(computedKeyAlgorithm);
        }
        if ((useKeyType = requestToken.getUseKey()) != null) {
            this.writeUseKeyType(useKeyType);
        }
        if ((onBehalfOf = requestToken.getOnBehalfOf()) != null) {
            this.writeOnBehalfOfType(onBehalfOf);
        }
        if ((validateTarget = requestToken.getValidateTarget()) != null) {
            this.writeValidateTargetType(validateTarget);
        }
        if ((cancelTarget = requestToken.getCancelTarget()) != null) {
            this.writeCancelTargetType(cancelTarget);
        }
        if ((renewTarget = requestToken.getRenewTarget()) != null) {
            this.writeRenewTargetType(renewTarget);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void writeEntropyType(EntropyType entropy) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Entropy", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<Object> entropyList = entropy.getAny();
        if (entropyList != null) {
            for (Object entropyObj : entropyList) {
                if (!(entropyObj instanceof BinarySecretType)) continue;
                BinarySecretType binarySecret = (BinarySecretType)entropyObj;
                this.writeBinarySecretType(this.writer, binarySecret);
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeComputedKeyAlgorithm(URI computedKeyAlgorithm) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"ComputedKeyAlgorithm", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)computedKeyAlgorithm.toASCIIString());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeUseKeyType(UseKeyType useKeyType) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"UseKey", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<Object> theList = useKeyType.getAny();
        for (Object useKeyTypeValue : theList) {
            if (useKeyTypeValue instanceof Element) {
                Element domElement = (Element)useKeyTypeValue;
                StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)domElement);
                continue;
            }
            if (useKeyTypeValue instanceof byte[]) {
                byte[] certificate = (byte[])useKeyTypeValue;
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"ds", (String)"X509Certificate", (String)"http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)new String(certificate));
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                continue;
            }
            if (useKeyTypeValue instanceof KeyValueType) {
                this.writeKeyValueType((KeyValueType)useKeyTypeValue);
                continue;
            }
            if (useKeyTypeValue instanceof KeyInfoType) {
                StaxWriterUtil.writeKeyInfo(this.writer, (KeyInfoType)useKeyTypeValue);
                continue;
            }
            throw logger.writerUnknownTypeError(useKeyTypeValue.getClass().getName());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeKeyValueType(KeyValueType type) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"ds", (String)"KeyValue", (String)"http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (type instanceof RSAKeyValueType) {
            RSAKeyValueType rsaKeyValue = (RSAKeyValueType)type;
            StaxWriterUtil.writeRSAKeyValueType(this.writer, rsaKeyValue);
        } else if (type instanceof DSAKeyValueType) {
            DSAKeyValueType dsaKeyValue = (DSAKeyValueType)type;
            StaxWriterUtil.writeDSAKeyValueType(this.writer, dsaKeyValue);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeOnBehalfOfType(OnBehalfOfType onBehalfOf) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"OnBehalfOf", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        UsernameTokenType usernameToken = (UsernameTokenType)onBehalfOf.getAny().get(0);
        WSSecurityWriter wsseWriter = new WSSecurityWriter(this.writer);
        wsseWriter.write(usernameToken);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeValidateTargetType(ValidateTargetType validateTarget) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"ValidateTarget", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<Object> list = validateTarget.getAny();
        for (Object validateTargetObj : list) {
            if (validateTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)validateTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (validateTargetObj instanceof Element) {
                StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)((Element)validateTargetObj));
                continue;
            }
            throw logger.writerUnknownTypeError(validateTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeRenewTargetType(RenewTargetType renewTarget) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RenewTarget", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<Object> list = renewTarget.getAny();
        for (Object renewTargetObj : list) {
            if (renewTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)renewTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (renewTargetObj instanceof Element) {
                StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)((Element)renewTargetObj));
                continue;
            }
            throw logger.writerUnknownTypeError(renewTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeCancelTargetType(CancelTargetType cancelTarget) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"CancelTarget", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<Object> list = cancelTarget.getAny();
        for (Object cancelTargetObj : list) {
            if (cancelTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)cancelTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (cancelTargetObj instanceof Element) {
                StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)((Element)cancelTargetObj));
                continue;
            }
            throw logger.writerUnknownTypeError(cancelTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeBinarySecretType(XMLStreamWriter writer, BinarySecretType binarySecret) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"wst", (String)"BinarySecret", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String type = binarySecret.getType();
        StaxUtil.writeAttribute((XMLStreamWriter)writer, (String)"Type", (String)type);
        StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)new String(binarySecret.getValue()));
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }

    private void writeRequestType(XMLStreamWriter writer, URI uri) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"wst", (String)"RequestType", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)uri.toASCIIString());
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }

    private void writeTokenType(XMLStreamWriter writer, URI uri) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)writer, (String)"wst", (String)"TokenType", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeCharacters((XMLStreamWriter)writer, (String)uri.toASCIIString());
        StaxUtil.writeEndElement((XMLStreamWriter)writer);
    }
}

