/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;
import org.apache.activemq.artemis.core.protocol.hornetq.util.HQPropertiesConverter;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class HQPropertiesConversionInterceptor
implements Interceptor {
    private final boolean replaceHQ;

    public HQPropertiesConversionInterceptor(boolean replaceHQ) {
        this.replaceHQ = replaceHQ;
    }

    public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
        if (HQPropertiesConverter.isMessagePacket(packet)) {
            this.handleReceiveMessage((MessagePacketI)packet);
        }
        return true;
    }

    private void handleReceiveMessage(MessagePacketI messagePacket) {
        if (this.replaceHQ) {
            HQPropertiesConverter.replaceHQProperties(messagePacket.getMessage());
        } else {
            HQPropertiesConverter.replaceAMQProperties(messagePacket.getMessage());
        }
    }
}

