/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshCommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.parser.CompleteStatus;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapCommandPopulator;
import org.aesh.command.map.MapProcessedCommandBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.parser.RequiredOptionException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedLineIterator;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;
import org.aesh.readline.AeshContext;
import org.aesh.utils.Config;

public class AeshCommandLineParser<C extends Command>
implements CommandLineParser<C> {
    private final ProcessedCommand<C> processedCommand;
    private List<CommandLineParser<C>> childParsers;
    private boolean isChild = false;
    private ProcessedOption lastParsedOption;
    private boolean parsedCommand = false;
    private final LineParser lineParser;
    private CompleteStatus completeStatus;

    public AeshCommandLineParser(ProcessedCommand<C> processedCommand) {
        this.processedCommand = processedCommand;
        this.lineParser = new LineParser();
    }

    @Override
    public void addChildParser(CommandLineParser<C> commandLineParser) throws CommandLineParserException {
        if (this.processedCommand.hasArgument() || this.processedCommand.hasArguments()) {
            throw new CommandLineParserException("Group commands can not have arguments defined");
        }
        if (this.childParsers == null) {
            this.childParsers = new ArrayList<CommandLineParser<C>>();
        }
        commandLineParser.setChild(true);
        this.childParsers.add(commandLineParser);
    }

    public List<CommandLineParser<C>> getChildParsers() {
        return this.childParsers;
    }

    @Override
    public void setChild(boolean child) {
        this.isChild = child;
    }

    @Override
    public CommandLineParser<C> parsedCommand() {
        if (this.parsedCommand) {
            return this;
        }
        if (this.isGroupCommand()) {
            for (CommandLineParser<C> child : this.childParsers) {
                CommandLineParser<C> correct = child.parsedCommand();
                if (correct == null) continue;
                return correct;
            }
        }
        return null;
    }

    @Override
    public void complete(AeshCompleteOperation completeOperation, InvocationProviders invocationProviders) {
        this.complete(completeOperation, new LineParser().parseLine(completeOperation.getBuffer(), completeOperation.getCursor(), true), invocationProviders);
    }

    @Override
    public void complete(AeshCompleteOperation completeOperation, ParsedLine line, InvocationProviders invocationProviders) {
        this.parse(line.iterator(), CommandLineParser.Mode.COMPLETION);
        this.parsedCommand().getCompletionParser().injectValuesAndComplete(completeOperation, invocationProviders, line);
    }

    @Override
    public List<String> getAllNames() {
        if (this.isGroupCommand()) {
            List<CommandLineParser<C>> parsers = this.getChildParsers();
            ArrayList<String> names = new ArrayList<String>(parsers.size());
            for (CommandLineParser<C> child : parsers) {
                names.add(this.processedCommand.name() + " " + child.getProcessedCommand().name());
            }
            return names;
        }
        ArrayList<String> names = new ArrayList<String>(1);
        names.add(this.processedCommand.name());
        return names;
    }

    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public CommandLineParser<C> getChildParser(String name) {
        if (!this.isGroupCommand()) {
            return null;
        }
        for (CommandLineParser<C> clp : this.getChildParsers()) {
            if (!clp.getProcessedCommand().name().equals(name)) continue;
            return clp;
        }
        return null;
    }

    @Override
    public List<CommandLineParser<C>> getAllChildParsers() {
        if (this.isGroupCommand()) {
            return this.getChildParsers();
        }
        return new ArrayList<CommandLineParser<C>>();
    }

    @Override
    public ProcessedCommand<C> getProcessedCommand() {
        return this.processedCommand;
    }

    @Override
    public C getCommand() {
        return this.processedCommand.getCommand();
    }

    @Override
    public CommandLineCompletionParser getCompletionParser() {
        return new AeshCommandLineCompletionParser(this);
    }

    @Override
    public CommandPopulator<Object, C> getCommandPopulator() {
        return this.processedCommand.getCommandPopulator();
    }

    @Override
    public void populateObject(String line, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode mode) throws CommandLineParserException, OptionValidatorException {
        this.parse(line, mode);
        if (mode == CommandLineParser.Mode.VALIDATE && this.getProcessedCommand().parserExceptions().size() > 0) {
            throw this.getProcessedCommand().parserExceptions().get(0);
        }
        this.doPopulate(this.processedCommand, invocationProviders, aeshContext, mode);
    }

    @Override
    public void doPopulate(ProcessedCommand processedCommand, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode mode) throws CommandLineParserException, OptionValidatorException {
        this.getCommandPopulator().populateObject(processedCommand, invocationProviders, aeshContext, mode);
        if (this.isGroupCommand()) {
            for (CommandLineParser<C> parser : this.getChildParsers()) {
                parser.doPopulate(parser.getProcessedCommand(), invocationProviders, aeshContext, mode);
            }
        }
    }

    @Override
    public String printHelp() {
        List<CommandLineParser<C>> parsers = this.getChildParsers();
        if (parsers != null && parsers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.processedCommand.printHelp()).append(Config.getLineSeparator()).append(this.processedCommand.name()).append(" commands:").append(Config.getLineSeparator());
            for (CommandLineParser<C> child : parsers) {
                sb.append("    ").append(child.getProcessedCommand().name()).append("  ").append(child.getProcessedCommand().description()).append(Config.getLineSeparator());
            }
            return sb.toString();
        }
        return this.processedCommand.printHelp();
    }

    @Override
    public void parse(String line) {
        this.parse(line, CommandLineParser.Mode.STRICT);
    }

    @Override
    public void parse(ParsedLineIterator iterator, CommandLineParser.Mode mode) {
        this.clear();
        if (iterator.hasNextWord()) {
            String command = iterator.pollWord();
            if (this.processedCommand.name().equals(command) || this.processedCommand.getAliases().contains(command)) {
                if (this.isGroupCommand() && iterator.hasNextWord()) {
                    CommandLineParser<C> clp = this.getChildParser(iterator.peekWord());
                    if (clp == null) {
                        if (iterator.isNextWordCursorWord() || iterator.peekWord().startsWith("--") || iterator.peekWord().startsWith("-")) {
                            this.doParse(iterator, mode);
                        } else {
                            this.processedCommand.addParserException(new CommandLineParserException("Wrong input for group command."));
                            if (mode == CommandLineParser.Mode.COMPLETION) {
                                this.parsedCommand = true;
                                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.INVALID_INPUT, ""));
                            }
                        }
                    } else {
                        clp.parse(iterator, mode);
                    }
                } else {
                    this.doParse(iterator, mode);
                }
            }
        } else if (iterator.parserError() != null) {
            this.processedCommand.addParserException(new CommandLineParserException(iterator.parserError()));
        }
    }

    private void doParse(ParsedLineIterator iter, CommandLineParser.Mode mode) {
        this.parsedCommand = true;
        if (mode == CommandLineParser.Mode.COMPLETION) {
            this.doParseCompletion(iter);
        } else {
            try {
                while (iter.hasNextWord()) {
                    ParsedWord word = iter.peekParsedWord();
                    this.lastParsedOption = this.processedCommand.searchAllOptions(word.word());
                    if (this.lastParsedOption != null) {
                        this.lastParsedOption.parser().parse(iter, this.lastParsedOption);
                        continue;
                    }
                    boolean unknown = false;
                    if (word.word().startsWith("-") && (word.word().startsWith("--") || word.word().length() == 2)) {
                        if (!(this.processedCommand.getCommand() instanceof MapCommand)) {
                            this.processedCommand.addParserException(new OptionParserException("The option " + word.word() + " is unknown."));
                        } else {
                            unknown = true;
                        }
                    }
                    if (unknown) {
                        MapCommandPopulator pop = (MapCommandPopulator)this.processedCommand.getCommandPopulator();
                        pop.addUnknownOption(word.word());
                    } else if (this.processedCommand.hasArguments()) {
                        this.processedCommand.getArguments().addValue(word.word());
                    } else if (this.processedCommand.hasArgumentWithNoValue()) {
                        this.processedCommand.getArgument().addValue(word.word());
                    } else {
                        this.processedCommand.addParserException(new OptionParserException("A value " + word.word() + " was given as an argument, but the command do not support it."));
                    }
                    iter.pollParsedWord();
                }
            }
            catch (OptionParserException ope) {
                this.processedCommand.addParserException(ope);
            }
            if (mode == CommandLineParser.Mode.STRICT) {
                MapCommand mc;
                if (this.processedCommand instanceof MapProcessedCommandBuilder.MapProcessedCommand && !(mc = (MapCommand)this.processedCommand.getCommand()).checkForRequiredOptions(iter.baseLine())) {
                    return;
                }
                RequiredOptionException re = this.checkForMissingRequiredOptions(this.processedCommand);
                if (re != null) {
                    this.processedCommand.addParserException(re);
                }
            }
        }
    }

    private void doParseCompletion(ParsedLineIterator iter) {
        if (this.processedCommand instanceof MapProcessedCommandBuilder.MapProcessedCommand) {
            ((MapProcessedCommandBuilder.MapProcessedCommand)this.processedCommand).setMode(CommandLineParser.Mode.COMPLETION);
        }
        if (!iter.hasNextWord()) {
            if (this.isGroupCommand()) {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, ""));
            } else if (iter.baseLine().size() == iter.baseLine().selectedIndex() + 1 && this.lastParsedOption == null) {
                if (iter.baseLine().status() == ParserStatus.OK) {
                    this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.APPEND_SPACE, ""));
                } else {
                    this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, ""));
                }
            } else {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.COMPLETE_OPTION, ""));
            }
        } else {
            while (iter.hasNextWord()) {
                try {
                    if (iter.baseLine().selectedIndex() > -1 && iter.pastCursorWord() && this.processedCommand.completeStatus() != null) {
                        return;
                    }
                    ParsedWord word = iter.peekParsedWord();
                    this.lastParsedOption = this.processedCommand.searchAllOptions(word.word());
                    if (this.lastParsedOption != null) {
                        if (iter.isNextWordCursorWord() && !word.word().contains("=") && this.processedCommand.findPossibleLongNames(word.word()).size() > 1) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.LONG_OPTION, word.word().substring(2)));
                            iter.pollParsedWord();
                            continue;
                        }
                        this.lastParsedOption.parser().parse(iter, this.lastParsedOption);
                        if (iter.hasNextWord()) continue;
                        if (this.lastParsedOption.hasValue() || iter.baseLine().spaceAtEnd()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.COMPLETE_OPTION, ""));
                            continue;
                        }
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.OPTION_MISSING_VALUE, ""));
                        continue;
                    }
                    if (word.word().startsWith("--")) {
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.LONG_OPTION, word.word().substring(2)));
                        iter.pollParsedWord();
                        continue;
                    }
                    if (word.word().startsWith("-")) {
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.SHORT_OPTION, word.word().substring(1)));
                        iter.pollParsedWord();
                        continue;
                    }
                    if (this.lastParsedOption == null && this.isGroupCommand()) {
                        if (iter.isNextWordCursorWord()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, word.word()));
                        } else if (iter.baseLine().cursorAtEnd() && iter.baseLine().spaceAtEnd()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, ""));
                        }
                    } else if (iter.isNextWordCursorWord()) {
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, word.word()));
                    } else if (this.processedCommand.hasArguments()) {
                        this.processedCommand.getArguments().addValue(word.word());
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, null));
                    } else if (this.processedCommand.hasArgument()) {
                        if (this.processedCommand.getArgument().getValue() == null) {
                            this.processedCommand.getArgument().addValue(word.word());
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, null));
                        } else {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT_ERROR, null));
                        }
                    }
                    iter.pollParsedWord();
                }
                catch (OptionParserException e) {
                    this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.OPTION_MISSING_VALUE, ""));
                }
            }
        }
    }

    private RequiredOptionException checkForMissingRequiredOptions(ProcessedCommand<C> command) {
        for (ProcessedOption o : command.getOptions()) {
            if (!this.doCheckForMissingRequiredOption(o)) continue;
            return new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
        if (command.getArgument() != null) {
            if (this.doCheckForMissingRequiredOption(command.getArgument())) {
                return new RequiredOptionException("Argument is required for this command.");
            }
        } else if (command.getArguments() != null && this.doCheckForMissingRequiredOption(command.getArguments())) {
            return new RequiredOptionException("Arguments is required for this command.");
        }
        return null;
    }

    private boolean doCheckForMissingRequiredOption(ProcessedOption o) {
        if (o.isRequired() && o.getValue() == null) {
            boolean found = false;
            for (ProcessedOption po : this.processedCommand.getOptions()) {
                if (po.getValue() == null || !po.doOverrideRequired()) continue;
                found = true;
                break;
            }
            if (!found) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ProcessedOption lastParsedOption() {
        return this.lastParsedOption;
    }

    @Override
    public void parse(String line, CommandLineParser.Mode mode) {
        this.parse(this.lineParser.parseLine(line, line.length()).iterator(), mode);
    }

    @Override
    public void clear() {
        if (this.parsedCommand) {
            this.processedCommand.clear();
            this.lastParsedOption = null;
            this.parsedCommand = false;
            this.completeStatus = null;
        } else {
            CommandLineParser<C> parsed = this.parsedCommand();
            if (parsed != null) {
                parsed.clear();
            }
        }
    }

    @Override
    public boolean isGroupCommand() {
        List<CommandLineParser<C>> parsers = this.getChildParsers();
        return parsers != null && parsers.size() > 0;
    }

    public String toString() {
        return "AeshCommandLineParser{processedCommand=" + this.processedCommand + ", childParsers=" + this.childParsers + ", isChild=" + this.isChild + ", lastParsedOption=" + this.lastParsedOption + ", parsedCommand=" + this.parsedCommand + ", completeStatus=" + this.completeStatus + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshCommandLineParser)) {
            return false;
        }
        AeshCommandLineParser that = (AeshCommandLineParser)o;
        return this.processedCommand.equals(that.processedCommand);
    }

    public int hashCode() {
        return this.processedCommand.hashCode();
    }
}

