/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class JavaUtils {
    static final char KEYWORD_PREFIX = '_';
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static boolean isJava9Compatible;

    private JavaUtils() {
    }

    public static boolean isJavaKeyword(String keyword) {
        return KEYWORDS.contains(keyword);
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static boolean isJava9Compatible() {
        return isJava9Compatible;
    }

    private static void setJava9Compatible(boolean java9Compatible) {
        isJava9Compatible = java9Compatible;
    }

    static {
        String version = System.getProperty("java.version");
        if (version.indexOf(46) > 0) {
            version = version.substring(0, version.indexOf(46));
        }
        if (version.indexOf("-") > 0) {
            version = version.substring(0, version.indexOf("-"));
        }
        JavaUtils.setJava9Compatible(Integer.valueOf(version) >= 9);
    }
}

