/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;

class RolesAllowedInterceptor
implements Interceptor {
    private final Collection<String> rolesAllowed;
    static final RolesAllowedInterceptor DENY_ALL = new RolesAllowedInterceptor(Collections.emptyList());

    RolesAllowedInterceptor(Collection<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        Iterator<String> iterator = this.rolesAllowed.iterator();
        if (iterator.hasNext()) {
            SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
            SecurityIdentity identity = securityDomain.getCurrentSecurityIdentity();
            Roles ejbRoles = identity.getRoles("ejb", true);
            do {
                String role;
                if (!ejbRoles.contains(role = iterator.next()) && (!role.equals("**") || identity.isAnonymous())) continue;
                return context.proceed();
            } while (iterator.hasNext());
        }
        throw EjbLogger.ROOT_LOGGER.invocationOfMethodNotAllowed(context.getMethod(), ((EJBComponent)component).getComponentName());
    }
}

