/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.sitraka.Filters;
import org.apache.tools.ant.taskdefs.optional.sitraka.Socket;
import org.apache.tools.ant.taskdefs.optional.sitraka.Triggers;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class Coverage
extends Task {
    protected File home;
    protected Commandline cmdl = new Commandline();
    protected CommandlineJava cmdlJava = new CommandlineJava();
    protected String function = "coverage";
    protected String seedName;
    protected File inputFile;
    protected File javaExe;
    protected String vm;
    protected boolean applet = false;
    protected String exitPrompt = "never";
    protected Filters filters = new Filters();
    protected Triggers triggers;
    protected String finalSnapshot = "coverage";
    protected String recordFromStart = "coverage";
    protected File snapshotDir;
    protected File workingDir;
    protected boolean trackNatives = false;
    protected Socket socket;
    protected int warnLevel = 0;
    protected Vector filesets = new Vector();

    public void setHome(File value) {
        this.home = value;
    }

    public void setSeedname(String value) {
        this.seedName = value;
    }

    public void setInputfile(File value) {
        this.inputFile = value;
    }

    public void setJavaexe(File value) {
        this.javaExe = value;
    }

    public void setVm(Javavm value) {
        this.vm = value.getValue();
    }

    public void setApplet(boolean value) {
        this.applet = value;
    }

    public void setExitprompt(String value) {
        this.exitPrompt = value;
    }

    public Filters createFilters() {
        return this.filters;
    }

    public Triggers createTriggers() {
        if (this.triggers == null) {
            this.triggers = new Triggers();
        }
        return this.triggers;
    }

    public Socket createSocket() {
        if (this.socket == null) {
            this.socket = new Socket();
        }
        return this.socket;
    }

    public void setFinalsnapshot(String value) {
        this.finalSnapshot = value;
    }

    public void setRecordfromstart(Recordfromstart value) {
        this.recordFromStart = value.getValue();
    }

    public void setWarnlevel(Integer value) {
        this.warnLevel = value;
    }

    public void setSnapshotdir(File value) {
        this.snapshotDir = value;
    }

    public void setWorkingdir(File value) {
        this.workingDir = value;
    }

    public void setTracknatives(boolean value) {
        this.trackNatives = value;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdlJava.createVmArgument();
    }

    public Commandline.Argument createArg() {
        return this.cmdlJava.createArgument();
    }

    public Path createClasspath() {
        return this.cmdlJava.createClasspath(((ProjectComponent)this).project).createPath();
    }

    public void setClassname(String value) {
        this.cmdlJava.setClassname(value);
    }

    public void addFileset(FileSet fs) {
        this.filesets.addElement(fs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File paramfile = null;
        if (this.inputFile == null) {
            this.checkOptions();
            paramfile = this.createParamFile();
        } else {
            paramfile = this.inputFile;
        }
        try {
            try {
                this.cmdl.setExecutable(new File(this.home, "jplauncher").getAbsolutePath());
                this.cmdl.createArgument().setValue("-jp_input=" + paramfile.getAbsolutePath());
                CoverageStreamHandler handler = new CoverageStreamHandler(this);
                Execute exec = new Execute((ExecuteStreamHandler)handler);
                this.log(this.cmdl.describeCommand(), 3);
                exec.setCommandline(this.cmdl.getCommandline());
                int exitValue = exec.execute();
                if (exitValue != 0) {
                    throw new BuildException("JProbe Coverage failed (" + exitValue + ")");
                }
                Object var6_6 = null;
                if (this.inputFile != null) return;
                if (paramfile == null) return;
                paramfile.delete();
                return;
            }
            catch (IOException e) {
                throw new BuildException("Failed to execute JProbe Coverage.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.inputFile != null) throw throwable;
            if (paramfile == null) throw throwable;
            paramfile.delete();
            throw throwable;
        }
    }

    protected void checkOptions() throws BuildException {
        String version;
        if (this.home == null || !this.home.isDirectory()) {
            throw new BuildException("Invalid home directory. Must point to JProbe home directory");
        }
        this.home = new File(this.home, "coverage");
        File jar = new File(this.home, "coverage.jar");
        if (!jar.exists()) {
            throw new BuildException("Cannot find Coverage directory: " + this.home);
        }
        if (this.snapshotDir == null) {
            this.snapshotDir = new File(".");
        }
        this.snapshotDir = ((ProjectComponent)this).project.resolveFile(this.snapshotDir.getPath());
        if (!this.snapshotDir.isDirectory() || !this.snapshotDir.exists()) {
            throw new BuildException("Snapshot directory does not exists :" + this.snapshotDir);
        }
        if (this.workingDir == null) {
            this.workingDir = new File(".");
        }
        this.workingDir = ((ProjectComponent)this).project.resolveFile(this.workingDir.getPath());
        if (this.javaExe == null && (this.vm == null || "java2".equals(this.vm)) && !(version = System.getProperty("java.version")).startsWith("1.1")) {
            if (this.vm == null) {
                this.vm = "java2";
            }
            String home = System.getProperty("java.home");
            boolean isUnix = File.separatorChar == '/';
            this.javaExe = isUnix ? new File(home, "bin/java") : new File(home, "/bin/java.exe");
        }
    }

    protected String[] getParameters() {
        Vector<String> params = new Vector<String>();
        params.addElement("-jp_function=" + this.function);
        if (this.vm != null) {
            params.addElement("-jp_vm=" + this.vm);
        }
        if (this.javaExe != null) {
            params.addElement("-jp_java_exe=" + ((ProjectComponent)this).project.resolveFile(this.javaExe.getPath()));
        }
        params.addElement("-jp_working_dir=" + this.workingDir.getPath());
        params.addElement("-jp_snapshot_dir=" + this.snapshotDir.getPath());
        params.addElement("-jp_record_from_start=" + this.recordFromStart);
        params.addElement("-jp_warn=" + this.warnLevel);
        if (this.seedName != null) {
            params.addElement("-jp_output_file=" + this.seedName);
        }
        params.addElement("-jp_filter=" + this.filters.toString());
        if (this.triggers != null) {
            params.addElement("-jp_trigger=" + this.triggers.toString());
        }
        if (this.finalSnapshot != null) {
            params.addElement("-jp_final_snapshot=" + this.finalSnapshot);
        }
        params.addElement("-jp_exit_prompt=" + this.exitPrompt);
        params.addElement("-jp_track_natives=" + this.trackNatives);
        String[] vmargs = this.cmdlJava.getVmCommand().getArguments();
        int i = 0;
        while (i < vmargs.length) {
            params.addElement(vmargs[i]);
            ++i;
        }
        Path classpath = this.cmdlJava.getClasspath();
        if (classpath != null && classpath.size() > 0) {
            params.addElement("-classpath " + classpath.toString());
        }
        if (this.cmdlJava.getClassname() != null) {
            params.addElement(this.cmdlJava.getClassname());
        }
        String[] args = this.cmdlJava.getJavaCommand().getArguments();
        int i2 = 0;
        while (i2 < args.length) {
            params.addElement(args[i2]);
            ++i2;
        }
        Object[] array = new String[params.size()];
        params.copyInto(array);
        return array;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File createParamFile() throws BuildException {
        File file = this.createTmpFile();
        this.log("Creating parameter file: " + file, 3);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            pw.println(params[i]);
            ++i;
        }
        pw.flush();
        this.log("JProbe Coverage parameters:\n" + sw.toString(), 3);
        FileWriter fw = null;
        fw = new FileWriter(file);
        fw.write(sw.toString());
        fw.flush();
        Object var9_7 = null;
        if (fw == null) return file;
        try {
            fw.close();
            return file;
        }
        catch (IOException ignored) {}
        return file;
        {
            catch (IOException e) {
                throw new BuildException("Could not write parameter file " + file, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected File createTmpFile() {
        long rand = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("jpcoverage" + rand + ".tmp");
        return file;
    }

    static class CoverageStreamHandler
    extends LogStreamHandler {
        CoverageStreamHandler(Task task) {
            super(task, 2, 1);
        }

        public void setProcessInputStream(OutputStream os) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Recordfromstart
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"coverage", "none", "all"};
        }
    }

    public static class Finalsnapshot
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"coverage", "none", "all"};
        }
    }

    public static class Javavm
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"java2", "jdk118", "jdk117"};
        }
    }
}

