/*
 * Decompiled with CFR 0.152.
 */
package br.cepel.sage.dashboardserver;

import br.cepel.sage.dashboardserver.IRepositoryDao;
import br.cepel.sage.dashboardserver.api.model.SageDashboardContentTypeDefinition;
import br.cepel.sage.dashboardserver.api.model.SageDashboardContentTypeInfo;
import java.util.List;
import spark.Request;
import spark.Response;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuBadRequestException;
import tecgraf.javautils.sparkserver.exceptions.JuNotFoundException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuRequestUtilities;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class ContentTypeController
extends JuController {
    private final IRepositoryDao dao;

    public ContentTypeController(IRepositoryDao dao) {
        this.dao = dao;
        this.getLogger().info("DAO: " + dao.getClass().getSimpleName());
        this.setPathPrefix("content-types");
        this.addEndpoint(JuVerb.GET, "", this.contentTypeInfos());
        this.addEndpoint(JuVerb.GET, ":id", this.contentTypeDefinition());
    }

    public JuIFunction<String> contentTypeInfos() {
        return (req, res) -> {
            List<SageDashboardContentTypeInfo> result = this.dao.contentTypeInfos();
            return JuResponseUtilities.setResponseAsJson((Response)res, (int)200, result);
        };
    }

    public JuIFunction<String> contentTypeDefinition() {
        return (req, res) -> {
            String sid = JuRequestUtilities.getRequestParameter((Request)req, (String)"id", (boolean)true);
            Long id = JuStringUtilities.longOrNull((String)sid);
            if (id == null) {
                throw new JuBadRequestException(String.format("Invalid content-type id '%s'", sid));
            }
            if (!this.dao.contentTypeExists(id)) {
                throw new JuNotFoundException(String.format("No content-type id '%s' found", sid));
            }
            SageDashboardContentTypeDefinition result = this.dao.contentTypeDefinition(id);
            return JuResponseUtilities.setResponseAsJson((Response)res, (int)200, (Object)result);
        };
    }
}

