/*
 * Decompiled with CFR 0.152.
 */
package br.cepel.sage.dashboardserver;

import br.cepel.sage.dashboardserver.IRepositoryDao;
import br.cepel.sage.dashboardserver.api.model.SageDashboardDefinition;
import br.cepel.sage.dashboardserver.api.model.SageDashboardInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuBadRequestException;
import tecgraf.javautils.sparkserver.exceptions.JuNotFoundException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuRequestUtilities;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class DashboardController
extends JuController {
    private final IRepositoryDao dao;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DashboardController(IRepositoryDao dao) {
        this.dao = dao;
        this.logger.info("DAO: " + dao.getClass().getSimpleName());
        this.setPathPrefix("dashboards");
        this.addEndpoint(JuVerb.GET, "", this.dashboardInfos());
        this.addEndpoint(JuVerb.GET, ":id", this.dashboardDefinition());
    }

    private JuIFunction<String> dashboardInfos() {
        return (req, res) -> {
            List<SageDashboardInfo> result = this.dao.dashboardInfos();
            return JuResponseUtilities.setResponseAsJson((Response)res, (int)200, result);
        };
    }

    private JuIFunction<String> dashboardDefinition() {
        return (req, res) -> {
            String sid = JuRequestUtilities.getRequestParameter((Request)req, (String)"id", (boolean)true);
            Long id = JuStringUtilities.longOrNull((String)sid);
            if (id == null) {
                throw new JuBadRequestException(String.format("Invalid content-type id '%s'", sid));
            }
            if (!this.dao.dashboardExists(id)) {
                throw new JuNotFoundException(String.format("No dashboard id '%s' found", sid));
            }
            SageDashboardDefinition result = this.dao.dashboardDefinition(id);
            return JuResponseUtilities.setResponseAsJson((Response)res, (int)200, (Object)result);
        };
    }
}

