/*
 * Decompiled with CFR 0.152.
 */
package br.cepel.sage.dashboardserver;

import br.cepel.sage.dashboardserver.ContentTypeController;
import br.cepel.sage.dashboardserver.DashboardController;
import br.cepel.sage.dashboardserver.LocalRepositoryDao;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.standard.JuServer;

public class DashboardServer {
    @Option(name="--port", usage="define a porta do servidor")
    private int port = 4444;
    @Option(name="--dao-type", usage="define o dao do servidor")
    public String daoType;
    @Option(name="--dao-local-repository-path", usage="define diret\u00f3rio do mock-dao do servidor")
    public String daoMockPath = "src/main/resources/data";

    public static void main(String[] args) {
        new DashboardServer().doMain(args);
    }

    private void doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            this.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }

    private void run() {
        JuServer server = JuServer.getInstance();
        LocalRepositoryDao dao = new LocalRepositoryDao(this.daoMockPath);
        DashboardController dashboardController = new DashboardController(dao);
        ContentTypeController contentTypeController = new ContentTypeController(dao);
        server.addController((JuIController)dashboardController);
        server.addController((JuIController)contentTypeController);
        server.setPort(this.port);
        try {
            server.start();
        }
        catch (Exception e) {
            System.err.println("Erro de start!");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

