/*
 * Decompiled with CFR 0.152.
 */
package br.cepel.sage.dashboardserver;

import br.cepel.sage.dashboardserver.IRepositoryDao;
import br.cepel.sage.dashboardserver.api.model.SageDashboardColumn;
import br.cepel.sage.dashboardserver.api.model.SageDashboardContentTypeDefinition;
import br.cepel.sage.dashboardserver.api.model.SageDashboardContentTypeInfo;
import br.cepel.sage.dashboardserver.api.model.SageDashboardDefinition;
import br.cepel.sage.dashboardserver.api.model.SageDashboardInfo;
import br.cepel.sage.dashboardserver.api.model.SageDashboardLine;
import br.cepel.sage.dashboardserver.api.model.SageDashboardSingleContent;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.utils.JuSparkUtilities;

public class LocalRepositoryDao
implements IRepositoryDao {
    private final String basePath;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public LocalRepositoryDao(String basePath) {
        File f = new File(basePath);
        if (!f.exists() || !f.isDirectory()) {
            String fmt = "Base path '%s' is not a accessible directory!";
            String err = String.format("Base path '%s' is not a accessible directory!", basePath);
            throw new IllegalStateException(err);
        }
        this.logger.info("Base path: " + basePath);
        this.basePath = basePath;
    }

    @Override
    public List<SageDashboardInfo> dashboardInfos() throws IOException {
        ArrayList<SageDashboardInfo> infos = new ArrayList<SageDashboardInfo>();
        long id = 1L;
        while (this.dashboardExists(id)) {
            SageDashboardDefinition definition = this.dashboardDefinition(id);
            SageDashboardInfo info = definition.getInfo();
            infos.add(info);
            ++id;
        }
        return infos;
    }

    @Override
    public SageDashboardDefinition dashboardDefinition(long id) throws IOException {
        String path = this.idToPathForDashboard(id);
        this.checkPath(path);
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        String json = new String(encoded, Charset.defaultCharset());
        SageDashboardDefinition definition = (SageDashboardDefinition)JuSparkUtilities.jsonToObject((String)json, SageDashboardDefinition.class);
        this.validateDashboardDefinition(id, definition);
        return definition;
    }

    @Override
    public boolean dashboardExists(long id) {
        String path = this.idToPathForDashboard(id);
        File file = Paths.get(path, new String[0]).toFile();
        return file.exists();
    }

    @Override
    public List<SageDashboardContentTypeInfo> contentTypeInfos() throws IOException {
        ArrayList<SageDashboardContentTypeInfo> infos = new ArrayList<SageDashboardContentTypeInfo>();
        long id = 1L;
        while (this.contentTypeExists(id)) {
            SageDashboardContentTypeDefinition definition = this.contentTypeDefinition(id);
            SageDashboardContentTypeInfo info = definition.getInfo();
            infos.add(info);
            ++id;
        }
        return infos;
    }

    @Override
    public SageDashboardContentTypeDefinition contentTypeDefinition(long id) throws IOException {
        String path = this.idToPathForContentType(id);
        this.checkPath(path);
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        String json = new String(encoded, Charset.defaultCharset());
        SageDashboardContentTypeDefinition definition = (SageDashboardContentTypeDefinition)JuSparkUtilities.jsonToObject((String)json, SageDashboardContentTypeDefinition.class);
        JsonSchema schema = this.createSchema(id, definition);
        if (schema == null) {
            String err = String.format("No schema for content-type %d", id);
            throw new IOException(err);
        }
        return definition;
    }

    @Override
    public boolean contentTypeExists(long id) {
        String path = this.idToPathForContentType(id);
        File file = Paths.get(path, new String[0]).toFile();
        return file.exists();
    }

    private JsonSchema createSchema(long id, SageDashboardContentTypeDefinition definition) throws IOException {
        JsonSchema schema;
        Object schemaObject = definition.getSchema();
        if (schemaObject == null) {
            String fmt = "No schema for content-type loaded as %d";
            String err = String.format("No schema for content-type loaded as %d", id);
            throw new IOException(err);
        }
        String schemaText = JuSparkUtilities.objectToJson((Object)schemaObject);
        try {
            JsonNode node = JuSparkUtilities.jsonToNode((String)schemaText);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
            schema = factory.getSchema(node);
        }
        catch (Exception e) {
            String fmt = "Cannot create schema for content-type loaded as %d\n%s";
            String err = String.format("Cannot create schema for content-type loaded as %d\n%s", id, e.getMessage());
            throw new IOException(err);
        }
        return schema;
    }

    public void validateDashboardDefinition(long id, SageDashboardDefinition definition) throws IOException {
        SageDashboardInfo info = definition.getInfo();
        if (info == null) {
            String fmt = "No info for dashboard loaded as %d";
            String err = String.format("No info for dashboard loaded as %d", id);
            throw new IOException(err);
        }
        this.validateDashboardInfo(id, info);
        this.validateContents(definition);
        this.validateReferences(definition);
    }

    private void validateDashboardInfo(long id, SageDashboardInfo info) throws IOException {
        Long dashId = info.getId();
        if (dashId == null) {
            String fmt = "No id for dashboard loaded as %d";
            String err = String.format("No id for dashboard loaded as %d", id);
            throw new IOException(err);
        }
        if (dashId != id) {
            String fmt = "Mismatched ids for dashboard loaded as id %d (internal id is %d)";
            String err = String.format("Mismatched ids for dashboard loaded as id %d (internal id is %d)", id, dashId);
            throw new IOException(err);
        }
        Long syntaxVersion = info.getSyntaxVersion();
        if (syntaxVersion == null) {
            String fmt = "No syntax-version for dashboard loaded as %d";
            String err = String.format("No syntax-version for dashboard loaded as %d", id);
            throw new IOException(err);
        }
    }

    private void validateContents(SageDashboardDefinition definition) throws IOException {
        List<SageDashboardSingleContent> contents = this.getAllContents(definition);
        for (SageDashboardSingleContent content : contents) {
            this.validateContent(content);
        }
    }

    private void validateContent(SageDashboardSingleContent content) throws IOException {
        Long typeId = content.getTypeId();
        if (typeId == null) {
            String title = content.getTitle() == null ? "<???>" : content.getTitle();
            String fmt = "No type-id for content '%s'";
            String err = String.format("No type-id for content '%s'", title);
            throw new IOException(err);
        }
        long tid = typeId;
        SageDashboardContentTypeDefinition typeDefinition = this.contentTypeDefinition(tid);
        JsonSchema schema = this.createSchema(tid, typeDefinition);
        Map<String, Object> configuration = content.getConfiguration();
        String cnf = JuSparkUtilities.objectToJson(configuration);
        JsonNode jsonNode = JuSparkUtilities.jsonToNode((String)cnf);
        try {
            Set validationMessages = schema.validate(jsonNode);
            boolean success = validationMessages.isEmpty();
            if (!success) {
                Iterator iterator = validationMessages.iterator();
                Object msg = "";
                if (iterator.hasNext()) {
                    ValidationMessage next = (ValidationMessage)iterator.next();
                    msg = (String)msg + next.getMessage() + "\n";
                }
                String title = content.getTitle();
                String fmt = "Bad configuration for content '%s' (type-id %d)\n%s";
                String err = String.format("Bad configuration for content '%s' (type-id %d)\n%s", title, tid, msg);
                throw new IOException(err);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            String title = content.getTitle() != null ? content.getTitle() : "<???>";
            String fmt = "Cannot validate configuration for content-type %d (content '%s')\n%s";
            String err = String.format("Cannot validate configuration for content-type %d (content '%s')\n%s", tid, title, msg);
            throw new IOException(err);
        }
    }

    private List<SageDashboardSingleContent> getAllContents(SageDashboardDefinition definition) {
        Collection<SageDashboardSingleContent> contents = definition.getContents().values();
        return new ArrayList<SageDashboardSingleContent>(contents);
    }

    private void validateReferences(SageDashboardDefinition definition) throws IOException {
        List<String> refs = this.getContentRefs(definition);
        Map<String, SageDashboardSingleContent> contentsMap = definition.getContents();
        for (String ref : refs) {
            if (contentsMap.containsKey(ref)) continue;
            String fmt = "Unknown reference to content: '%s'";
            String err = String.format("Unknown reference to content: '%s'", ref);
            throw new IOException(err);
        }
    }

    private List<String> getContentRefs(SageDashboardDefinition definition) {
        List<SageDashboardColumn> columns;
        ArrayList<String> refs = new ArrayList<String>();
        List<SageDashboardLine> lines = definition.getLayout().getLines();
        if (lines != null) {
            lines.forEach(l -> this.getContentRefs((List<String>)refs, (SageDashboardLine)l));
        }
        if ((columns = definition.getLayout().getColumns()) != null) {
            columns.forEach(c -> this.getContentRefs((List<String>)refs, (SageDashboardColumn)c));
        }
        return refs;
    }

    private void getContentRefs(List<String> refs, SageDashboardLine line) {
        List<String> stackRefs;
        String contentReference;
        List<SageDashboardColumn> columns = line.getColumns();
        if (columns != null) {
            columns.forEach(c -> this.getContentRefs(refs, (SageDashboardColumn)c));
        }
        if ((contentReference = line.getSingleContentReference()) != null) {
            refs.add(contentReference);
        }
        if ((stackRefs = line.getStack()) != null) {
            refs.addAll(stackRefs);
        }
    }

    private void getContentRefs(List<String> refs, SageDashboardColumn column) {
        List<String> stackRefs;
        String contentReference;
        List<SageDashboardLine> lines = column.getLines();
        if (lines != null) {
            lines.forEach(c -> this.getContentRefs(refs, (SageDashboardLine)c));
        }
        if ((contentReference = column.getSingleContentReference()) != null) {
            refs.add(contentReference);
        }
        if ((stackRefs = column.getStack()) != null) {
            refs.addAll(stackRefs);
        }
    }

    private String idToPathForDashboard(long id) {
        return this.idToPath("dashboards", id);
    }

    private String idToPathForContentType(long id) {
        return this.idToPath("content-types", id);
    }

    private String idToPath(String dirName, long id) {
        String path = String.format("%s/%s/%03d.json", this.basePath, dirName, id);
        return path;
    }

    private void checkPath(String path) throws IOException {
        File file = Paths.get(path, new String[0]).toFile();
        if (!file.exists()) {
            String fmt = "File not found: %s";
            String err = String.format("File not found: %s", path);
            throw new IOException(err);
        }
        if (!file.isFile()) {
            String fmt = "Path is not a regular file: %s";
            String err = String.format("Path is not a regular file: %s", path);
            throw new IOException(err);
        }
        if (!file.canRead()) {
            String fmt = "Path is not readable: %s";
            String err = String.format("Path is not readable: %s", path);
            throw new IOException(err);
        }
    }
}

