/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import java.util.Formatter;
import java.util.Locale;
import umontreal.ssj.probdist.BetaDist;
import umontreal.ssj.probdist.HypoExponentialDist;
import umontreal.ssj.util.PrintfFormat;

public class HypoExponentialDistEqual
extends HypoExponentialDist {
    private double m_h;
    private int m_n;
    private int m_k;

    public HypoExponentialDistEqual(int n, int k, double h) {
        super(null);
        this.setParams(n, k, h);
    }

    @Override
    public double density(double x) {
        return HypoExponentialDistEqual.density(this.m_n, this.m_k, this.m_h, x);
    }

    @Override
    public double cdf(double x) {
        return HypoExponentialDistEqual.cdf(this.m_n, this.m_k, this.m_h, x);
    }

    @Override
    public double barF(double x) {
        return HypoExponentialDistEqual.barF(this.m_n, this.m_k, this.m_h, x);
    }

    @Override
    public double inverseF(double u) {
        return HypoExponentialDistEqual.inverseF(this.m_n, this.m_k, this.m_h, u);
    }

    public static double density(int n, int k, double h, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double r = -Math.expm1(-h * x);
        double v = BetaDist.density(k, n - k + 1, r);
        return h * v * Math.exp(-h * x);
    }

    public static double cdf(int n, int k, double h, double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double r = -Math.expm1(-h * x);
        double u = BetaDist.cdf(k, n - k + 1, r);
        return u;
    }

    public static double barF(int n, int k, double h, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        double r = Math.exp(-h * x);
        double v = BetaDist.cdf(n - k + 1, k, r);
        return v;
    }

    public static double inverseF(int n, int k, double h, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        double z = BetaDist.inverseF(k, n - k + 1, u);
        return -Math.log1p(-z) / h;
    }

    @Override
    public double[] getParams() {
        double[] par = new double[]{this.m_n, this.m_k, this.m_h};
        return par;
    }

    public void setParams(int n, int k, double h) {
        this.m_n = n;
        this.m_k = k;
        this.m_h = h;
        this.m_lambda = new double[k];
        for (int i = 0; i < k; ++i) {
            this.m_lambda[i] = (double)(n - i) * h;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format(this.getClass().getSimpleName() + " : params = {" + PrintfFormat.NEWLINE, new Object[0]);
        formatter.format("   %d, %d, %f", this.m_n, this.m_k, this.m_h);
        formatter.format("}%n", new Object[0]);
        return sb.toString();
    }
}

