/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.CommonListRequest;
import com.baidubce.services.iotdmp.model.CommonResult;
import com.baidubce.services.iotdmp.model.c2c.ComputationSourceResponse;
import com.baidubce.services.iotdmp.model.device.AuthRequest;
import com.baidubce.services.iotdmp.model.device.CreateDeviceRequest;
import com.baidubce.services.iotdmp.model.device.DeviceInfo;
import com.baidubce.services.iotdmp.model.device.DeviceResourcesConnectionInfo;
import com.baidubce.services.iotdmp.model.device.ListDeviceRequest;
import com.baidubce.services.iotdmp.model.device.ListDeviceResponse;
import com.baidubce.services.iotdmp.model.device.ResourcesRequest;
import com.baidubce.services.iotdmp.model.device.UpdateDeviceStateRequest;
import com.baidubce.services.iotdmp.model.device.evs.AddEvsDeviceRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsDeviceInfo;
import com.baidubce.services.iotdmp.model.device.evs.EvsDurationRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsProtocolRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsPtzRequest;
import com.baidubce.services.iotdmp.model.device.tag.CommonTagInfo;
import com.baidubce.services.iotdmp.model.device.tag.CreateTagRequest;
import com.baidubce.services.iotdmp.model.device.tag.ListTagResponse;
import com.baidubce.services.iotdmp.model.device.topic.ListTopicResponse;
import com.baidubce.services.iotdmp.model.instance.CreateInstanceRequest;
import com.baidubce.services.iotdmp.model.instance.ExtensionResourceResponse;
import com.baidubce.services.iotdmp.model.instance.InstanceInfo;
import com.baidubce.services.iotdmp.model.instance.ListInstancesResponse;
import com.baidubce.services.iotdmp.model.instance.UpdateInstanceRequest;
import com.baidubce.services.iotdmp.model.platform.BatchDeleteRuleChainExternalDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.BatchDeleteRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainExternalDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainResponse;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainDestinationResponse;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainResponse;
import com.baidubce.services.iotdmp.model.platform.PlatformRuleChainInfo;
import com.baidubce.services.iotdmp.model.platform.UpdatePlatformRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.UpdateRuleChainStateRequest;
import com.baidubce.services.iotdmp.model.platform.ValidateRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.ValidateRuleChainResponse;
import com.baidubce.services.iotdmp.model.product.CreateProductInfoRequest;
import com.baidubce.services.iotdmp.model.product.ListProductRequest;
import com.baidubce.services.iotdmp.model.product.ListProductResponse;
import com.baidubce.services.iotdmp.model.product.PermanentConnectRequest;
import com.baidubce.services.iotdmp.model.product.ProductInfo;
import com.baidubce.services.iotdmp.model.product.UpdateProductInfoRequest;
import com.baidubce.services.iotdmp.model.product.evs.CreateEvsSpaceRequest;
import com.baidubce.services.iotdmp.model.product.evs.EvsSpaceInfo;
import com.baidubce.services.iotdmp.model.product.evs.UpdateEvsSpaceRequest;
import com.baidubce.services.iotdmp.model.product.feature.command.CreateFeatureCommandRequest;
import com.baidubce.services.iotdmp.model.product.feature.command.ListFeatureCommandResponse;
import com.baidubce.services.iotdmp.model.product.feature.command.ProductFeatureCommandInfo;
import com.baidubce.services.iotdmp.model.product.feature.command.UpdateProductCommandRequest;
import com.baidubce.services.iotdmp.model.product.feature.event.CreateFeatureEventRequest;
import com.baidubce.services.iotdmp.model.product.feature.event.ListFeatureEventResponse;
import com.baidubce.services.iotdmp.model.product.feature.event.ProductFeatureEventInfo;
import com.baidubce.services.iotdmp.model.product.feature.event.UpdateProductEventRequest;
import com.baidubce.services.iotdmp.model.product.feature.property.CreateFeaturePropertyRequest;
import com.baidubce.services.iotdmp.model.product.feature.property.ProductFeaturePropertyInfo;
import com.baidubce.services.iotdmp.model.product.feature.property.UpdateProductPropertyRequest;
import com.baidubce.services.iotdmp.model.service.ConsumerGroupQueueInfoResponse;
import com.baidubce.services.iotdmp.model.service.ConsumerGroupUserInfoResponse;
import com.baidubce.services.iotdmp.model.service.CreateConsumerGroupRequest;
import com.baidubce.services.iotdmp.model.service.CreateConsumerGroupResponse;
import com.baidubce.services.iotdmp.model.service.ListConsumerGroupResponse;
import com.baidubce.services.iotdmp.model.service.ListSubResponse;
import com.baidubce.services.iotdmp.model.service.MessageTypeResponse;
import com.baidubce.services.iotdmp.model.service.ProductSubscriptionResponse;
import com.baidubce.services.iotdmp.model.service.ResetConsumerGroupUserPwdResponse;
import com.baidubce.services.iotdmp.model.service.SendMessageRequest;
import com.baidubce.services.iotdmp.model.service.UpdateProductSubscriptionRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.AvailableMessageTypeResponse;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicDecodeRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicDecodeResponse;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicEncodeRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicEncodeResponse;
import com.baidubce.services.iotdmp.model.shadow.DeviceShadowResponse;
import com.baidubce.services.iotdmp.model.shadow.ListDeviceShadowRequest;
import com.baidubce.services.iotdmp.model.shadow.ShadowStatesRequest;
import com.baidubce.services.iotdmp.model.shadow.UpdateDesiredRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PlatformClient
extends AbstractBceClient {
    private static final String ENDPOINT = "TBD";
    private static final String VERSION = "v1";
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String INSTANCE = "instances";
    private static final String EXTENSION = "extensions";
    private static final String AVAILABLE = "available";
    private static final String CONFIG = "config";
    private static final String ENABLED = "enabled";
    private static final String PLATFORM_RULECHAINS = "platform/rulechains";
    private static final String BATCH_DELETE = "batchDelete";
    private static final String UPDATE_STATE = "updateState";
    private static final String COMPUTE = "compute";
    private static final String DESTINATIONS = "destinations";
    private static final String SERVICE = "services";
    private static final String C2C = "c2c";
    private static final String DEVICE = "devices";
    private static final String SECRET = "secret";
    private static final String TOPICS = "topics";
    private static final String TAGS = "tags";
    private static final String EVS = "evs";
    private static final String CHANNEL = "channel";
    private static final String PTZ = "ptz";
    private static final String THUMBNAIL = "thumbnail";
    private static final String RECORDING = "recording";
    private static final String RESOURCES = "resources";
    private static final String STATES = "states";
    private static final String AUTH = "auth";
    private static final String SHADOW = "shadows";
    private static final String DESIRED = "desired";
    private static final String SIGNED_URL = "signedUrl";
    private static final String PRODUCT = "products";
    private static final String PERMANENT_CONNECT = "permanentConnect";
    private static final String FEATURE = "features";
    private static final String DETAIL = "detail";
    private static final String COMMAND = "commands";
    private static final String EVENT = "events";
    private static final String PROPERTIES = "properties";
    private static final String MESSAGES = "messages";
    private static final String BLINK = "blink";
    private static final String ENCODE = "encode";
    private static final String DECODE = "decode";
    private static final String MESSAGE = "message";
    private static final String TYPES = "types";
    private static final String TYPE = "type";
    private static final String SOURCE = "sources";
    private static final String SINK = "sinks";
    private static final String CONSUMER = "consumers";
    private static final String USER = "user";
    private static final String RESET = "reset";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public PlatformClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    public PlatformClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public InstanceInfo createInstance(CreateInstanceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE);
        return this.invokeHttpClient(internalRequest, InstanceInfo.class);
    }

    public void deleteInstance(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, INSTANCE, instanceId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public InstanceInfo updateInstance(String instanceId, UpdateInstanceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE, instanceId);
        return this.invokeHttpClient(internalRequest, InstanceInfo.class);
    }

    public InstanceInfo getInstance(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, instanceId);
        return this.invokeHttpClient(internalRequest, InstanceInfo.class);
    }

    public ListInstancesResponse listInstances(int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public ExtensionResourceResponse getAvailableExtensionResources() {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, EXTENSION, AVAILABLE);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getConfigExtensionResources(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, instanceId, EXTENSION, CONFIG);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getConfigExtensionResources(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, EXTENSION, CONFIG);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getConfigExtensionResources(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EXTENSION, CONFIG);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getEnabledExtensionResources(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, instanceId, EXTENSION, ENABLED);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getEnabledExtensionResources(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, EXTENSION, ENABLED);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getEnabledExtensionResources(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EXTENSION, ENABLED);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public CreateRuleChainResponse createRuleChain(String instanceId, CreateRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId);
        return this.invokeHttpClient(internalRequest, CreateRuleChainResponse.class);
    }

    public void deleteRuleChain(String instanceId, Set<String> rulechainIds) {
        BatchDeleteRuleChainRequest request = new BatchDeleteRuleChainRequest(rulechainIds);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, BATCH_DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateRuleChain(String instanceId, String rulechainId, UpdatePlatformRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PLATFORM_RULECHAINS, instanceId, rulechainId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateRuleChainState(String instanceId, String rulechainId, UpdateRuleChainStateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PLATFORM_RULECHAINS, instanceId, rulechainId, UPDATE_STATE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public PlatformRuleChainInfo getRuleChain(String instanceId, String rulechainId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId, rulechainId);
        return this.invokeHttpClient(internalRequest, PlatformRuleChainInfo.class);
    }

    public ListRuleChainResponse listRuleChain(String instanceId, ListRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getState())) {
            internalRequest.addParameter("state", request.getState());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListRuleChainResponse.class);
    }

    public ValidateRuleChainResponse validateRuleChain(ValidateRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, COMPUTE);
        return this.invokeHttpClient(internalRequest, ValidateRuleChainResponse.class);
    }

    public CommonResult createRuleChainExternalDestination(String instanceId, CreateRuleChainExternalDestinationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ListRuleChainDestinationResponse listRuleChainDestinations(String instanceId, ListRuleChainDestinationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId, DESTINATIONS);
        internalRequest.addParameter("sourceType", request.getSourceType());
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegion())) {
            internalRequest.addParameter("region", request.getRegion());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        return this.invokeHttpClient(internalRequest, ListRuleChainDestinationResponse.class);
    }

    public void batchDeleteRuleChainExternalDestinations(String instanceId, Set<String> destinationIds) {
        BatchDeleteRuleChainExternalDestinationRequest request = new BatchDeleteRuleChainExternalDestinationRequest(destinationIds);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS, BATCH_DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult validateRuleChainDestinationConnect(String instanceId, String destId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS, destId);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ComputationSourceResponse getC2CSource(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, C2C);
        return this.invokeHttpClient(internalRequest, ComputationSourceResponse.class);
    }

    public DeviceInfo createDevice(String instanceId, String productKey, CreateDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, DeviceInfo.class);
    }

    public void deleteDevice(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DEVICE, instanceId, productKey, deviceName);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceInfo getDevice(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceInfo.class);
    }

    public ListDeviceResponse getDeviceList(String instanceId, ListDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getProductKey())) {
            internalRequest.addParameter("productKey", request.getProductKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlias())) {
            internalRequest.addParameter("alias", request.getAlias());
        }
        return this.invokeHttpClient(internalRequest, ListDeviceResponse.class);
    }

    public void resetDeviceSecret(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, DEVICE, instanceId, productKey, deviceName, SECRET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTopicResponse getDeviceTopic(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, TOPICS);
        return this.invokeHttpClient(internalRequest, ListTopicResponse.class);
    }

    public ListTagResponse createTag(String instanceId, String productKey, String deviceName, List<CommonTagInfo> tags) {
        CreateTagRequest request = new CreateTagRequest(tags);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, instanceId, productKey, deviceName, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public void deleteTag(String instanceId, String productKey, String deviceName, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DEVICE, instanceId, productKey, deviceName, TAGS, key);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse getTagList(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public EvsSpaceInfo getEvs(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, EVS);
        return this.invokeHttpClient(internalRequest, EvsSpaceInfo.class);
    }

    public EvsDeviceInfo getEvs(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EVS);
        return this.invokeHttpClient(internalRequest, EvsDeviceInfo.class);
    }

    public void createEvs(String instanceId, String productKey, CreateEvsSpaceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createEvs(String instanceId, String productKey, String deviceName, AddEvsDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, instanceId, productKey, deviceName, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult getEvsChannelUrl(String instanceId, String productKey, String deviceName, String channelId, EvsProtocolRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EVS, CHANNEL, channelId);
        if (request.getProtocol() != null) {
            internalRequest.addParameter("protocol", request.getProtocol().name());
        }
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public void getEvsChannelPtz(String instanceId, String productKey, String deviceName, String channelId, EvsPtzRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE, instanceId, productKey, deviceName, EVS, CHANNEL, channelId, PTZ);
        internalRequest.addParameter(PTZ, request.getPtzCommand());
        internalRequest.addParameter("speed", Integer.toString(request.getSpeed()));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult getEvsChannel(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EVS, CHANNEL);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public CommonResult getEvsThumbnail(String instanceId, String productKey, String deviceName, EvsDurationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EVS, THUMBNAIL);
        internalRequest.addParameter("begin", Integer.toString(request.getBegin()));
        internalRequest.addParameter("end", Integer.toString(request.getEnd()));
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public CommonResult getEvsRecording(String instanceId, String productKey, String deviceName, EvsDurationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE, instanceId, productKey, deviceName, EVS, RECORDING);
        internalRequest.addParameter("begin", Integer.toString(request.getBegin()));
        internalRequest.addParameter("end", Integer.toString(request.getEnd()));
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public void auth(String instanceId, String productKey, String deviceName, AuthRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, instanceId, productKey, deviceName, AUTH);
        internalRequest.addHeader("signature", request.getSignature());
        internalRequest.addHeader("expiryTime", Long.toString(request.getExpiryTime()));
        if (request.getAlgorithmType() != null) {
            internalRequest.addHeader("algorithmType", request.getAlgorithmType().name());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceResourcesConnectionInfo getResourcesInfo(String instanceId, String productKey, String deviceName, ResourcesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, instanceId, productKey, deviceName, RESOURCES);
        return this.invokeHttpClient(internalRequest, DeviceResourcesConnectionInfo.class);
    }

    public void updateStates(String instanceId, String productKey, String deviceName, UpdateDeviceStateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE, instanceId, productKey, deviceName, STATES);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceShadowResponse getDeviceShadow(String instanceId, String productKey, String deviceName, ListDeviceShadowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SHADOW, instanceId, productKey, deviceName);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getPropertyName())) {
            internalRequest.addParameter("propertyName", request.getPropertyName());
        }
        return this.invokeHttpClient(internalRequest, DeviceShadowResponse.class);
    }

    public void updateDeviceShadowState(String instanceId, String productKey, boolean shadowState) {
        ShadowStatesRequest request = new ShadowStatesRequest();
        request.setShadowState(shadowState);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SHADOW, instanceId, productKey, STATES);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDesired(String instanceId, String productKey, String deviceName, Map<String, Object> desired) {
        UpdateDesiredRequest request = new UpdateDesiredRequest(desired);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SHADOW, instanceId, productKey, deviceName, DESIRED);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult getEvsStream(String domain, String app, String stream, EvsProtocolRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, EVS, domain, app, stream, SIGNED_URL);
        internalRequest.addParameter("protocol", request.getProtocol().name());
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ProductInfo createProduct(String instanceId, CreateProductInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public void resetSecret(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, PRODUCT, instanceId, productKey, SECRET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductInfo updateProduct(String instanceId, String productKey, UpdateProductInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCT, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public ListProductResponse getProductList(String instanceId, ListProductRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PRODUCT, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getProductName())) {
            internalRequest.addParameter("productName", request.getProductName());
        }
        return this.invokeHttpClient(internalRequest, ListProductResponse.class);
    }

    public ProductInfo getProduct(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public void deleteProduct(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCT, instanceId, productKey);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updatePermanentConnect(String instanceId, String productKey, boolean permanentConnect) {
        PermanentConnectRequest request = new PermanentConnectRequest(permanentConnect);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, PERMANENT_CONNECT);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse createProductTag(String instanceId, String productKey, List<CommonTagInfo> tags) {
        CreateTagRequest request = new CreateTagRequest(tags);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public void deleteProductTag(String instanceId, String productKey, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCT, instanceId, productKey, TAGS, key);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse getProductTagList(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public ListTopicResponse getTopics(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, TOPICS);
        return this.invokeHttpClient(internalRequest, ListTopicResponse.class);
    }

    public CommonResult getDTMLDetail(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PRODUCT, instanceId, productKey, FEATURE, DETAIL);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ProductFeatureCommandInfo createFeatureCommand(String instanceId, String productKey, CreateFeatureCommandRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, FEATURE, COMMAND);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public ProductFeatureCommandInfo updateFeatureCommand(String instanceId, String productKey, String name, UpdateProductCommandRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCT, instanceId, productKey, FEATURE, COMMAND, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public void deleteFeatureCommand(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCT, instanceId, productKey, FEATURE, COMMAND, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeatureCommandInfo getFeatureCommand(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, COMMAND, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public ListFeatureCommandResponse getFeatureCommandList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, COMMAND);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureCommandResponse.class);
    }

    public ProductFeatureEventInfo createFeatureEvent(String instanceId, String productKey, CreateFeatureEventRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, FEATURE, EVENT);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public ProductFeatureEventInfo updateFeatureEvent(String instanceId, String productKey, String name, UpdateProductEventRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCT, instanceId, productKey, FEATURE, EVENT, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public void deleteFeatureEvent(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCT, instanceId, productKey, FEATURE, EVENT, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeatureEventInfo getFeatureEvent(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, EVENT, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public ListFeatureEventResponse getFeatureEventList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, EVENT);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureEventResponse.class);
    }

    public ProductFeaturePropertyInfo createFeatureProperty(String instanceId, String productKey, CreateFeaturePropertyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, instanceId, productKey, FEATURE, PROPERTIES);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public ProductFeaturePropertyInfo updateFeatureProperty(String instanceId, String productKey, String name, UpdateProductPropertyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCT, instanceId, productKey, FEATURE, PROPERTIES, name);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public void deleteFeatureProperty(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCT, instanceId, productKey, FEATURE, PROPERTIES, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeaturePropertyInfo getFeatureProperty(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, PROPERTIES, name);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public ListFeatureEventResponse getFeaturePropertyList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCT, instanceId, productKey, FEATURE, PROPERTIES);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureEventResponse.class);
    }

    public void updateEvs(String instanceId, String productKey, UpdateEvsSpaceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCT, instanceId, productKey, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public TopicEncodeResponse topicEncode(TopicEncodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, BLINK, TOPICS, ENCODE);
        return this.invokeHttpClient(internalRequest, TopicEncodeResponse.class);
    }

    public TopicDecodeResponse topicDecode(TopicDecodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, BLINK, TOPICS, DECODE);
        return this.invokeHttpClient(internalRequest, TopicDecodeResponse.class);
    }

    public AvailableMessageTypeResponse getSourceTypes(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGES, TYPES, SOURCE);
        return this.invokeHttpClient(internalRequest, AvailableMessageTypeResponse.class);
    }

    public AvailableMessageTypeResponse getSinkTypes(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGES, TYPES, SINK);
        return this.invokeHttpClient(internalRequest, AvailableMessageTypeResponse.class);
    }

    public ConsumerGroupUserInfoResponse getUserInfo(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, CONSUMER, USER);
        return this.invokeHttpClient(internalRequest, ConsumerGroupUserInfoResponse.class);
    }

    public void sendMessage(String instanceId, String productKey, String deviceName, SendMessageRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, instanceId, productKey, deviceName, MESSAGE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateConsumerGroupResponse createConsumerGroup(String instanceId, String name) {
        CreateConsumerGroupRequest request = new CreateConsumerGroupRequest(name);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, instanceId, CONSUMER);
        return this.invokeHttpClient(internalRequest, CreateConsumerGroupResponse.class);
    }

    public void deleteConsumerGroup(String instanceId, String consumerGroupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, SERVICE, instanceId, CONSUMER, consumerGroupId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListConsumerGroupResponse getConsumerGroupList(String instanceId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SERVICE, instanceId, CONSUMER);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListConsumerGroupResponse.class);
    }

    public ResetConsumerGroupUserPwdResponse resetUserPwd(String instanceId, String username) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, CONSUMER, username, RESET);
        return this.invokeHttpClient(internalRequest, ResetConsumerGroupUserPwdResponse.class);
    }

    public ConsumerGroupQueueInfoResponse getQueueInfo(String instanceId, String consumerGroupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, CONSUMER, consumerGroupId);
        return this.invokeHttpClient(internalRequest, ConsumerGroupQueueInfoResponse.class);
    }

    public ListSubResponse getSubList(String instanceId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, SUBSCRIPTIONS);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListSubResponse.class);
    }

    public ProductSubscriptionResponse getSub(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        return this.invokeHttpClient(internalRequest, ProductSubscriptionResponse.class);
    }

    public void updateSub(String instanceId, String productKey, UpdateProductSubscriptionRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateSubState(String instanceId, String productKey, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        internalRequest.addParameter("state", Boolean.toString(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public MessageTypeResponse getMessageType(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGE, TYPE);
        return this.invokeHttpClient(internalRequest, MessageTypeResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, request);
        }
        return request;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

