/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public class ValueFilter {
    private String operation;
    private String value;
    private static final String SINGLE_QUOTATION = "'";
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String GREATER = ">";
    public static final String LESS = "<";
    public static final String GREATER_OR_EQUAL = ">=";
    public static final String LESS_OR_EQUAL = "<=";
    public static final List<String> LONG_DOUBLE_SUPPORTED_OPERATION = Arrays.asList("=", "!=", ">", "<", ">=", "<=");
    public static final List<String> STRING_SUPPORTED_OPERATION = Arrays.asList("=", "!=", ">", "<", ">=", "<=");
    public static final List<String> TAG_SUPPORTED_OPERATION = LONG_DOUBLE_SUPPORTED_OPERATION;

    public ValueFilter() {
    }

    public ValueFilter(String operation, String value) {
        this.operation = operation;
        this.value = value;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getValue() {
        return this.value;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ValueFilter createValueFilter(String operation, String value) {
        Preconditions.checkArgument((boolean)STRING_SUPPORTED_OPERATION.contains(operation), (Object)("String value only support operations in " + STRING_SUPPORTED_OPERATION.toString()));
        ValueFilter valueFilter = new ValueFilter(operation, SINGLE_QUOTATION + value + SINGLE_QUOTATION);
        return valueFilter;
    }

    public static ValueFilter createValueFilter(String operation, Double value) {
        Preconditions.checkArgument((boolean)LONG_DOUBLE_SUPPORTED_OPERATION.contains(operation), (Object)("Double value only support operations in " + LONG_DOUBLE_SUPPORTED_OPERATION.toString()));
        ValueFilter valueFilter = new ValueFilter(operation, String.valueOf(value));
        return valueFilter;
    }

    public static ValueFilter createValueFilter(String operation, Long value) {
        Preconditions.checkArgument((boolean)LONG_DOUBLE_SUPPORTED_OPERATION.contains(operation), (Object)("Long value only support operations in " + LONG_DOUBLE_SUPPORTED_OPERATION.toString()));
        ValueFilter valueFilter = new ValueFilter(operation, String.valueOf(value));
        return valueFilter;
    }

    public static ValueFilter createValueFilterOfTag(String operation, String tagKey) {
        Preconditions.checkArgument((boolean)TAG_SUPPORTED_OPERATION.contains(operation), (Object)("Value of tag key only support operations in " + TAG_SUPPORTED_OPERATION.toString()));
        ValueFilter valueFilter = new ValueFilter(operation, tagKey);
        return valueFilter;
    }
}

