/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class IpHelper {
    private static final Logger logger = Logger.getLogger("IpHelper");
    private static String LOCAL_IP_STAR_STR = "192.168.";
    public static final String LOCAL_IP;
    public static final String HOST_NAME;

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
                ip = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.severe("IpHelper error." + e.toString());
            }
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    static {
        String ip = null;
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            InetAddress[] ipAddr = InetAddress.getAllByName(hostName);
            for (int i = 0; i < ipAddr.length && !(ip = ipAddr[i].getHostAddress()).startsWith(LOCAL_IP_STAR_STR); ++i) {
            }
            if (ip == null) {
                ip = ipAddr[0].getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.severe("IpHelper error.");
            e.printStackTrace();
        }
        LOCAL_IP = ip;
        HOST_NAME = hostName;
    }
}

