/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.captcha.filter.library;

import com.baomidou.kisso.common.captcha.filter.library.AbstractTransformImageOp;
import com.baomidou.kisso.common.captcha.filter.library.PerlinNoise;

public class MarbleImageOp
extends AbstractTransformImageOp {
    double scale = 15.0;
    double amount = 1.1;
    double turbulence = 6.2;
    double[] tx;
    double[] ty;
    double randomX = 256.0 * Math.random();
    double randomY = 256.0 * Math.random();

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setTurbulence(double turbulence) {
        this.turbulence = turbulence;
    }

    @Override
    protected synchronized void init() {
        this.tx = new double[256];
        this.ty = new double[256];
        for (int i = 0; i < 256; ++i) {
            double angle = Math.PI * 2 * (double)i * this.turbulence / 256.0;
            this.tx[i] = this.amount * Math.sin(angle);
            this.ty[i] = this.amount * Math.cos(angle);
        }
    }

    @Override
    protected void transform(int x, int y, double[] t) {
        int d = this.limitByte((int)(127.0 * (1.0 + PerlinNoise.noise2D((double)x / this.scale + this.randomX, (double)y / this.scale + this.randomY))));
        t[0] = (double)x + this.tx[d];
        t[1] = (double)y + this.ty[d];
    }

    protected void filter2(int[] inPixels, int[] outPixels, int width, int height) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = this.limitByte((int)(127.0 * (1.0 + PerlinNoise.noise2D((double)x / this.scale + this.randomX, (double)y / this.scale + this.randomY))));
                outPixels[x + y * width] = this.limitByte(255) << 24 | this.limitByte(pixel) << 16 | this.limitByte(pixel) << 8 | this.limitByte(pixel);
            }
        }
    }
}

