/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.pathcmd;

import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.PathCommand;
import java.awt.geom.GeneralPath;

public class QuadraticSmooth
extends PathCommand {
    public float x = 0.0f;
    public float y = 0.0f;

    public QuadraticSmooth() {
    }

    public QuadraticSmooth(boolean isRelative, float x, float y) {
        super(isRelative);
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(GeneralPath path, BuildHistory hist) {
        float offx = this.isRelative ? hist.history[0].x : 0.0f;
        float offy = this.isRelative ? hist.history[0].y : 0.0f;
        float oldKx = hist.history.length >= 2 ? hist.history[1].x : hist.history[0].x;
        float oldKy = hist.history.length >= 2 ? hist.history[1].y : hist.history[0].y;
        float oldX = hist.history[0].x;
        float oldY = hist.history[0].y;
        float kx = oldX * 2.0f - oldKx;
        float ky = oldY * 2.0f - oldKy;
        path.quadTo(kx, ky, this.x + offx, this.y + offy);
        hist.setPointAndKnot(this.x + offx, this.y + offy, kx, ky);
    }

    @Override
    public int getNumKnotsAdded() {
        return 4;
    }
}

