/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageComponent
extends JComponent {
    private List<Painter> painters = new ArrayList<Painter>();
    private Image image;
    private Dimension imageSize;

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
        if (!this.painters.isEmpty()) {
            for (Painter painter : this.painters) {
                painter.paint(g, this);
            }
        }
    }

    public void addPainter(@NotNull Painter painter) {
        this.painters.add(painter);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.imageSize != null) {
            return this.imageSize;
        }
        return super.getPreferredSize();
    }

    public void setImage(@NotNull File imageFile) throws IOException {
        this.setImage(ImageIO.read(imageFile));
    }

    public void setImage(@Nullable Image image) {
        this.image = image;
        if (image == null) {
            this.imageSize = null;
        } else {
            int width = image.getWidth(this);
            int height = image.getHeight(this);
            this.imageSize = new Dimension(width, height);
        }
        this.revalidate();
        this.repaint();
    }

    public static interface Painter {
        public void paint(@NotNull Graphics var1, @NotNull JComponent var2);
    }
}

