/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import smile.hash.MurmurHash;
import smile.math.distance.HammingDistance;
import smile.neighbor.KNNSearch;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.sort.HeapSelect;

public class SNLSH<E>
implements NearestNeighborSearch<AbstractSentence, E>,
KNNSearch<AbstractSentence, E>,
RNNSearch<AbstractSentence, E> {
    private final int bandSize;
    private final long mask;
    private static final int BITS = 64;
    private Band[] bands;
    private List<E> data;
    private List<AbstractSentence> keys;
    private List<Long> signs;
    private boolean identicalExcluded = true;

    public SNLSH(int bandSize) {
        if (bandSize < 2 || bandSize > 32) {
            throw new IllegalArgumentException("Invalid band size!");
        }
        this.bandSize = bandSize;
        this.bands = (Band[])Array.newInstance(Band.class, bandSize);
        Arrays.fill(this.bands, new Band());
        this.mask = -1 >>> 64 / bandSize * (bandSize - 1);
        this.data = new ArrayList();
        this.keys = new ArrayList<AbstractSentence>();
        this.signs = new ArrayList<Long>();
    }

    public void put(AbstractSentence sentence, E v) {
        int index = this.data.size();
        this.data.add(v);
        this.keys.add(sentence);
        long sign = SNLSH.simhash64(sentence.tokens);
        this.signs.add(sign);
        for (int i = 0; i < this.bands.length; ++i) {
            long bandKey = this.bandHash(sign, i);
            Bucket bucket = (Bucket)this.bands[i].get(bandKey);
            if (bucket == null) {
                bucket = new Bucket();
            }
            bucket.add(index);
            this.bands[i].put(bandKey, bucket);
        }
    }

    @Override
    public Neighbor<AbstractSentence, E>[] knn(AbstractSentence q, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        long fpq = SNLSH.simhash64(q.tokens);
        Set<Integer> candidates = this.obtainCandidates(q.tokens);
        Comparable[] neighbors = (Neighbor[])Array.newInstance(Neighbor.class, k);
        HeapSelect heap = new HeapSelect(neighbors);
        Neighbor<Object, Object> neighbor = new Neighbor<Object, Object>(null, null, 0, Double.MAX_VALUE);
        for (int i = 0; i < k; ++i) {
            heap.add(neighbor);
        }
        int hit = 0;
        for (int index : candidates) {
            long sign;
            double distance;
            AbstractSentence key = this.keys.get(index);
            if (q.line == key.line && this.identicalExcluded || !((distance = (double)HammingDistance.d((long)fpq, (long)(sign = this.signs.get(index).longValue()))) < ((Neighbor)heap.peek()).distance)) continue;
            heap.add(new Neighbor<AbstractSentence, E>(this.keys.get(index), this.data.get(index), index, distance));
            ++hit;
        }
        heap.sort();
        if (hit < k) {
            Neighbor[] n2 = (Neighbor[])Array.newInstance(Neighbor.class, hit);
            int start = k - hit;
            for (int i = 0; i < hit; ++i) {
                n2[i] = neighbors[i + start];
            }
            neighbors = n2;
        }
        return neighbors;
    }

    @Override
    public Neighbor<AbstractSentence, E> nearest(AbstractSentence q) {
        Neighbor<AbstractSentence, E>[] ns = this.knn(q, 1);
        if (ns.length > 0) {
            return ns[0];
        }
        return new Neighbor<Object, Object>(null, null, -1, Double.MAX_VALUE);
    }

    @Override
    public void range(AbstractSentence q, double radius, List<Neighbor<AbstractSentence, E>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        long fpq = SNLSH.simhash64(q.tokens);
        Set<Integer> candidates = this.obtainCandidates(q.tokens);
        for (int index : candidates) {
            double distance = HammingDistance.d((long)fpq, (long)this.signs.get(index));
            if (!(distance <= radius) || this.keys.get((int)index).line == q.line && this.identicalExcluded) continue;
            neighbors.add(new Neighbor<AbstractSentence, E>(this.keys.get(index), this.data.get(index), index, distance));
        }
    }

    private long bandHash(long hash, int bandNum) {
        return hash >>> bandNum * (64 / this.bandSize) & this.mask;
    }

    private Set<Integer> obtainCandidates(List<String> q) {
        HashSet<Integer> candidates = new HashSet<Integer>();
        long sign = SNLSH.simhash64(q);
        for (int i = 0; i < this.bands.length; ++i) {
            long bandKey = this.bandHash(sign, i);
            Bucket bucket = (Bucket)this.bands[i].get(bandKey);
            if (bucket == null) continue;
            candidates.addAll(bucket);
        }
        return candidates;
    }

    protected static long simhash64(List<String> tokens) {
        long seed = 0L;
        int BITS = 64;
        if (tokens == null || tokens.isEmpty()) {
            return 0L;
        }
        int[] bits = new int[64];
        for (String s : tokens) {
            ByteBuffer buffer = ByteBuffer.wrap(s.getBytes());
            long hc = MurmurHash.hash2_64((ByteBuffer)buffer, (int)0, (int)buffer.array().length, (long)0L);
            for (int i = 0; i < 64; ++i) {
                if ((hc >>> i & 1L) == 1L) {
                    int n = i;
                    bits[n] = bits[n] + 1;
                    continue;
                }
                int n = i;
                bits[n] = bits[n] - 1;
            }
        }
        long hash = 0L;
        long one = 1L;
        for (int i = 0; i < 64; ++i) {
            if (bits[i] >= 0) {
                hash |= one;
            }
            one <<= 1;
        }
        return hash;
    }

    public static abstract class AbstractSentence {
        public String line;
        public List<String> tokens;

        abstract List<String> tokenize(String var1);
    }

    private class Bucket
    extends LinkedList<Integer> {
        private Bucket() {
        }
    }

    private class Band
    extends LinkedHashMap<Long, Bucket> {
        private Band() {
        }
    }
}

