/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;
import smile.projection.Projection;

public class PPCA
implements Projection<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double[] mu;
    private double[] pmu;
    private double noise;
    private DenseMatrix loading;
    private DenseMatrix projection;

    public DenseMatrix getLoadings() {
        return this.loading;
    }

    public double[] getCenter() {
        return this.mu;
    }

    public double getNoiseVariance() {
        return this.noise;
    }

    public DenseMatrix getProjection() {
        return this.projection;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.mu.length));
        }
        double[] y = new double[this.projection.nrows()];
        this.projection.ax(x, y);
        Math.minus((double[])y, (double[])this.pmu);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.mu.length));
        }
        double[][] y = new double[x.length][this.projection.nrows()];
        for (int i = 0; i < x.length; ++i) {
            this.projection.ax(x[i], y[i]);
            Math.minus((double[])y[i], (double[])this.pmu);
        }
        return y;
    }

    public PPCA(double[][] data, int k) {
        int i;
        int m = data.length;
        int n = data[0].length;
        this.mu = Math.colMeans((double[][])data);
        DenseMatrix cov = Matrix.zeros((int)n, (int)n);
        for (int l = 0; l < m; ++l) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j <= i2; ++j) {
                    cov.add(i2, j, (data[l][i2] - this.mu[i2]) * (data[l][j] - this.mu[j]));
                }
            }
        }
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j <= i3; ++j) {
                cov.div(i3, j, (double)m);
                cov.set(j, i3, cov.get(i3, j));
            }
        }
        cov.setSymmetric(true);
        EVD eigen = cov.eigen();
        double[] evalues = eigen.getEigenValues();
        DenseMatrix evectors = eigen.getEigenVectors();
        this.noise = 0.0;
        for (i = k; i < n; ++i) {
            this.noise += evalues[i];
        }
        this.noise /= (double)(n - k);
        this.loading = Matrix.zeros((int)n, (int)k);
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                this.loading.set(i, j, evectors.get(i, j) * Math.sqrt((double)(evalues[j] - this.noise)));
            }
        }
        DenseMatrix M = this.loading.ata();
        for (int i4 = 0; i4 < k; ++i4) {
            M.add(i4, i4, this.noise);
        }
        Cholesky chol = M.cholesky();
        DenseMatrix Mi = chol.inverse();
        this.projection = (DenseMatrix)Mi.abtmm((Object)this.loading);
        this.pmu = new double[this.projection.nrows()];
        this.projection.ax(this.mu, this.pmu);
    }
}

