/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.utils.IValidationChecker;
import com.itextpdf.kernel.utils.ValidationContext;
import com.itextpdf.pdfua.checkers.utils.GraphicsCheckUtil;
import com.itextpdf.pdfua.checkers.utils.LayoutCheckUtil;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class PdfUA1Checker
implements IValidationChecker {
    private final PdfDocument pdfDocument;
    private final TagStructureContext tagStructureContext;

    public PdfUA1Checker(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.tagStructureContext = new TagStructureContext(pdfDocument);
    }

    public void validateDocument(ValidationContext validationContext) {
        this.checkCatalog(validationContext.getPdfDocument().getCatalog());
        this.checkStructureTreeRoot(validationContext.getPdfDocument().getStructTreeRoot());
        this.checkFonts(validationContext.getFonts());
    }

    public void validateObject(Object obj, IsoKey key, PdfResources resources, PdfStream contentStream, Object extra) {
        switch (key) {
            case LAYOUT: {
                LayoutCheckUtil.checkLayoutElements(obj);
                break;
            }
            case CANVAS_WRITING_CONTENT: {
                this.checkOnWritingCanvasToContent(obj);
                break;
            }
            case CANVAS_BEGIN_MARKED_CONTENT: {
                this.checkOnOpeningBeginMarkedContent(obj, extra);
            }
        }
    }

    private void checkOnWritingCanvasToContent(Object data) {
        Stack<Tuple2<PdfName, PdfDictionary>> tagStack = this.getTagStack(data);
        if (tagStack.isEmpty()) {
            throw new PdfUAConformanceException("Tag hasn't been added before adding content to the canvas.");
        }
        boolean insideRealContent = this.isInsideRealContent(tagStack);
        boolean insideArtifact = this.isInsideArtifact(tagStack);
        if (insideRealContent && insideArtifact) {
            throw new PdfUAConformanceException("Tagged content is present inside content marked as Artifact or vice versa.");
        }
        if (!insideRealContent && !insideArtifact) {
            throw new PdfUAConformanceException("Content is neither marked as Artifact nor tagged as real content.");
        }
    }

    private Stack<Tuple2<PdfName, PdfDictionary>> getTagStack(Object data) {
        return (Stack)data;
    }

    private void checkOnOpeningBeginMarkedContent(Object obj, Object extra) {
        Tuple2 currentBmc = (Tuple2)extra;
        this.checkStandardRoleMapping((Tuple2<PdfName, PdfDictionary>)currentBmc);
        Stack<Tuple2<PdfName, PdfDictionary>> stack = this.getTagStack(obj);
        if (stack.isEmpty()) {
            return;
        }
        boolean isRealContent = this.isRealContent((Tuple2<PdfName, PdfDictionary>)currentBmc);
        boolean isArtifact = PdfName.Artifact.equals(currentBmc.getFirst());
        if (isArtifact && this.isInsideRealContent(stack)) {
            throw new PdfUAConformanceException("Content marked as artifact may only reside in Artifact content.");
        }
        if (isRealContent && this.isInsideArtifact(stack)) {
            throw new PdfUAConformanceException("Content marked as content may not reside in Artifact content.");
        }
    }

    private void checkStandardRoleMapping(Tuple2<PdfName, PdfDictionary> tag) {
        PdfNamespace namespace = this.tagStructureContext.getDocumentDefaultNamespace();
        String role = ((PdfName)tag.getFirst()).getValue();
        if (!"Artifact".equals(role) && !this.tagStructureContext.checkIfRoleShallBeMappedToStandardRole(role, namespace)) {
            throw new PdfUAConformanceException(MessageFormatUtil.format((String)"\"{0}\" tag mapping does not terminate with a standard type.", (Object[])new Object[]{role}));
        }
    }

    private boolean isInsideArtifact(Stack<Tuple2<PdfName, PdfDictionary>> tagStack) {
        for (Tuple2 tuple2 : tagStack) {
            if (!PdfName.Artifact.equals(tuple2.getFirst())) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideRealContent(Stack<Tuple2<PdfName, PdfDictionary>> tagStack) {
        for (Tuple2 tuple2 : tagStack) {
            if (!this.isRealContent((Tuple2<PdfName, PdfDictionary>)tuple2)) continue;
            return true;
        }
        return false;
    }

    private boolean isRealContent(Tuple2<PdfName, PdfDictionary> tag) {
        if (PdfName.Artifact.equals(tag.getFirst())) {
            return false;
        }
        PdfDictionary properties = (PdfDictionary)tag.getSecond();
        if (properties == null || !properties.containsKey(PdfName.MCID)) {
            return false;
        }
        PdfMcr mcr = this.pdfDocument.getStructTreeRoot().findMcrByMcid(this.pdfDocument, properties.getAsInt(PdfName.MCID).intValue());
        if (mcr == null) {
            throw new PdfUAConformanceException("Content with MCID, but MCID wasn't found in StructTreeRoot.");
        }
        return true;
    }

    private void checkCatalog(PdfCatalog catalog) {
        PdfBoolean markInfoSuspects;
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        if (!catalogDict.containsKey(PdfName.Metadata)) {
            throw new PdfUAConformanceException("Metadata shall be present in the catalog dictionary");
        }
        PdfDictionary markInfo = catalogDict.getAsDictionary(PdfName.MarkInfo);
        if (markInfo != null && markInfo.containsKey(PdfName.Suspects) && (markInfoSuspects = markInfo.getAsBoolean(PdfName.Suspects)) != null && markInfoSuspects.getValue()) {
            throw new PdfUAConformanceException("Suspects entry in mark info dictionary shall not have a value of true.");
        }
    }

    private void checkStructureTreeRoot(PdfStructTreeRoot structTreeRoot) {
        PdfDictionary roleMap = structTreeRoot.getRoleMap();
        for (Map.Entry entry : roleMap.entrySet()) {
            String role = ((PdfName)entry.getKey()).getValue();
            IRoleMappingResolver roleMappingResolver = this.pdfDocument.getTagStructureContext().getRoleMappingResolver(role);
            if (!roleMappingResolver.currentRoleIsStandard()) continue;
            throw new PdfUAConformanceException("One or more standard types are remapped.");
        }
        TagTreeIterator tagTreeIterator = new TagTreeIterator((IStructureNode)structTreeRoot);
        tagTreeIterator.addHandler(GraphicsCheckUtil.createFigureTagHandler());
        tagTreeIterator.traverse();
    }

    private void checkFonts(Collection<PdfFont> fontsInDocument) {
        HashSet<String> fontNamesThatAreNotEmbedded = new HashSet<String>();
        for (PdfFont font : fontsInDocument) {
            if (font.isEmbedded()) continue;
            fontNamesThatAreNotEmbedded.add(font.getFontProgram().getFontNames().getFontName());
        }
        if (!fontNamesThatAreNotEmbedded.isEmpty()) {
            throw new PdfUAConformanceException(MessageFormatUtil.format((String)"Following font(s) are not embedded: {0}", (Object[])new Object[]{String.join((CharSequence)", ", fontNamesThatAreNotEmbedded)}));
        }
    }
}

