/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList
extends JList {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private CheckBoxListSelectionModel _checkBoxListSelectionModel;
    protected Handler _handler;
    @Deprecated
    public static final String ALL = "(All)";
    public static final Object ALL_ENTRY = new AllEntry();

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector<?> listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(Object[] listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    public void setModel(ListModel model) {
        super.setModel(model);
        if (this.getCheckBoxListSelectionModel() != null) {
            this.getCheckBoxListSelectionModel().clearSelection();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void init() {
        this._checkBoxListSelectionModel = this.createCheckBoxListSelectionModel(this.getModel());
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        this._handler = this.createHandler();
        this._checkBoxListSelectionModel.addListSelectionListener(this._handler);
        JideSwingUtilities.insertMouseListener(this, this._handler, 0);
        this.addKeyListener(this._handler);
        this.addPropertyChangeListener("model", this._handler);
        ListModel model = this.getModel();
        if (model != null) {
            model.addListDataListener(this._handler);
        }
    }

    @Override
    public int getLastVisibleIndex() {
        int visibleIndex = super.getLastVisibleIndex();
        if (visibleIndex < 0) {
            return this.getModel().getSize() - 1;
        }
        return visibleIndex;
    }

    protected CheckBoxListSelectionModel createCheckBoxListSelectionModel(ListModel model) {
        return new CheckBoxListSelectionModel(model);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(this.getActualCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        return super.getCellRenderer();
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled(int index) {
        return true;
    }

    public boolean isCheckBoxVisible(int index) {
        return true;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            boolean old = this._checkBoxEnabled;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, old, this._checkBoxEnabled);
            this.repaint();
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean clickInCheckBoxOnly) {
        if (clickInCheckBoxOnly != this._clickInCheckBoxOnly) {
            boolean old = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = clickInCheckBoxOnly;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this._clickInCheckBoxOnly);
        }
    }

    public CheckBoxListSelectionModel getCheckBoxListSelectionModel() {
        return this._checkBoxListSelectionModel;
    }

    public void setCheckBoxListSelectionModel(CheckBoxListSelectionModel checkBoxListSelectionModel) {
        this._checkBoxListSelectionModel = checkBoxListSelectionModel;
        this._checkBoxListSelectionModel.setModel(this.getModel());
    }

    public int[] getCheckBoxListSelectedIndices() {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] temp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (listSelectionModel.isAllEntryConsidered() && i == listSelectionModel.getAllEntryIndex() || !listSelectionModel.isSelectedIndex(i)) continue;
            temp[n] = i;
            ++n;
        }
        int[] indices = new int[n];
        System.arraycopy(temp, 0, indices, 0, n);
        return indices;
    }

    public void setCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void addCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void removeCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().removeSelectionInterval(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckBoxListSelectedIndices(int[] indices) {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        try {
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel.clearSelection();
            int size = this.getModel().getSize();
            for (int indice : indices) {
                if (indice < 0 || indice >= size) continue;
                listSelectionModel.addSelectionInterval(indice, indice);
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void setSelectedObjects(Object[] elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    public void setSelectedObjects(Vector<?> elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    private void setSelectedObjects(Map<Object, String> selected) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object elementAt = this.getModel().getElementAt(i);
            if (selected.get(elementAt) == null) continue;
            indices.add(i);
        }
        int[] selectedIndices = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            Integer row = (Integer)indices.get(i);
            selectedIndices[i] = row;
        }
        this.setCheckBoxListSelectedIndices(selectedIndices);
    }

    public Object[] getCheckBoxListSelectedValues() {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        ListModel model = this.getModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] temp = new Object[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (listSelectionModel.isAllEntryConsidered() && i == listSelectionModel.getAllEntryIndex() || !listSelectionModel.isSelectedIndex(i)) continue;
            temp[n] = model.getElementAt(i);
            ++n;
        }
        Object[] indices = new Object[n];
        System.arraycopy(temp, 0, indices, 0, n);
        return indices;
    }

    public int getCheckBoxListSelectedIndex() {
        return this.getCheckBoxListSelectionModel().getMinSelectionIndex();
    }

    public Object getCheckBoxListSelectedValue() {
        int i = this.getCheckBoxListSelectionModel().getMinSelectionIndex();
        return i == -1 ? null : this.getModel().getElementAt(i);
    }

    public void setCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel model = this.getModel();
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(model.getElementAt(i))) continue;
                this.setCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public void addCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        ListModel model = this.getModel();
        if (anObject != null) {
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(model.getElementAt(i))) continue;
                this.addCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
        } else {
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (model.getElementAt(i) != null) continue;
                this.addCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
        }
    }

    public void addCheckBoxListSelectedValues(Object[] objects) {
        if (objects != null) {
            HashMap<Object, String> map = new HashMap<Object, String>();
            for (Object o : objects) {
                map.put(o, "");
            }
            ListModel model = this.getModel();
            boolean changed = false;
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (map.get(model.getElementAt(i)) == null) continue;
                this.addCheckBoxListSelectedIndex(i);
                changed = true;
            }
            if (changed) {
                this.repaint();
            }
            map.clear();
        }
    }

    public void removeCheckBoxListSelectedValues(Object[] objects) {
        if (objects != null) {
            HashMap<Object, String> map = new HashMap<Object, String>();
            for (Object o : objects) {
                map.put(o, "");
            }
            ListModel model = this.getModel();
            boolean changed = false;
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (map.get(model.getElementAt(i)) == null) continue;
                this.removeCheckBoxListSelectedIndex(i);
                changed = true;
            }
            if (changed) {
                this.repaint();
            }
            map.clear();
        }
    }

    public void removeCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel model = this.getModel();
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(model.getElementAt(i))) continue;
                this.removeCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
        }
    }

    public void clearCheckBoxListSelection() {
        this.getCheckBoxListSelectionModel().clearSelection();
    }

    public void selectAll() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
        }
    }

    public void selectNone() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return size != null && size.width > 0 && size.height > 0 ? JideSwingUtilities.adjustPreferredScrollableViewportSize(this, size) : size;
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        protected CheckBoxList _list;
        int hotspot;

        public Handler(CheckBoxList list) {
            this.hotspot = new JCheckBox().getPreferredSize().width;
            this._list = list;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() instanceof ListModel) {
                ((ListModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ListModel) {
                this._list.getCheckBoxListSelectionModel().setModel((ListModel)evt.getNewValue());
                ((ListModel)evt.getNewValue()).addListDataListener(this);
            }
        }

        protected boolean clicksInCheckBox(MouseEvent e) {
            int index = this._list.locationToIndex(e.getPoint());
            Rectangle bounds = this._list.getCellBounds(index, index);
            if (bounds != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return e.getX() < bounds.x + this.hotspot;
                }
                return e.getX() > bounds.x + bounds.width - this.hotspot;
            }
            return false;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            boolean clickInBox = this.clicksInCheckBox(e);
            if (!this._list.isClickInCheckBoxOnly() || clickInBox) {
                int index = this._list.locationToIndex(e.getPoint());
                this.toggleSelection(index);
                if (clickInBox) {
                    e.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (this.clicksInCheckBox(e)) {
                e.consume();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelections() {
            int[] indices = this._list.getSelectedIndices();
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            selectionModel.removeListSelectionListener(this);
            selectionModel.setValueIsAdjusting(true);
            try {
                if (indices.length > 0) {
                    boolean selected = selectionModel.isSelectedIndex(indices[0]);
                    for (int index : indices) {
                        if (!this._list.isCheckBoxEnabled(index)) continue;
                        if (selected && selectionModel.isSelectedIndex(index)) {
                            selectionModel.removeSelectionInterval(index, index);
                            continue;
                        }
                        if (selected || selectionModel.isSelectedIndex(index)) continue;
                        selectionModel.addSelectionInterval(index, index);
                    }
                }
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this._list.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelection(int index) {
            if (!this._list.isEnabled() || !this._list.isCheckBoxEnabled(index)) {
                return;
            }
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            boolean selected = selectionModel.isSelectedIndex(index);
            selectionModel.removeListSelectionListener(this);
            try {
                if (selected) {
                    selectionModel.removeSelectionInterval(index, index);
                } else {
                    selectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int index = this._list.getSelectedIndex();
            this.toggleSelection(index);
        }

        public void intervalAdded(ListDataEvent e) {
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            CheckBoxListSelectionModel listSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            CheckBoxListSelectionModel listSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
        }

        public void contentsChanged(ListDataEvent e) {
        }
    }

    private static final class AllEntry {
        public String toString() {
            return CheckBoxList.ALL;
        }
    }
}

