/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultConnectionTester
extends AbstractConnectionTester {
    static final MLogger logger = MLog.getLogger(DefaultConnectionTester.class);
    static final int HASH_CODE = DefaultConnectionTester.class.getName().hashCode();
    static final Set INVALID_DB_STATES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int activeCheckConnection(Connection c, String query, Throwable[] rootCauseOutParamHolder) {
        int n;
        if (query == null) {
            return this.activeCheckConnectionNoQuery(c, rootCauseOutParamHolder);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery(query);
            n = 0;
        }
        catch (SQLException e) {
            block13: {
                String state;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + c + " failed Connection test with an Exception! [query=" + query + "]", (Throwable)e);
                }
                if (rootCauseOutParamHolder != null) {
                    rootCauseOutParamHolder[0] = e;
                }
                if (!INVALID_DB_STATES.contains(state = e.getSQLState())) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (test with query '" + query + "') implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", (Throwable)e);
                }
                int n2 = -8;
                ResultSetUtils.attemptClose((ResultSet)rs);
                StatementUtils.attemptClose((Statement)stmt);
                return n2;
            }
            int n3 = -1;
            ResultSetUtils.attemptClose((ResultSet)rs);
            StatementUtils.attemptClose((Statement)stmt);
            return n3;
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c + " failed Connection test with an Exception!", (Throwable)e2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e2;
            }
            int n4 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(rs);
                    StatementUtils.attemptClose((Statement)stmt);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose((ResultSet)rs);
            StatementUtils.attemptClose((Statement)stmt);
            return n4;
        }
        ResultSetUtils.attemptClose((ResultSet)rs);
        StatementUtils.attemptClose((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int statusOnException(Connection c, Throwable t, String query, Throwable[] rootCauseOutParamHolder) {
        block12: {
            block13: {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Testing a Connection in response to an Exception:", t);
                }
                if (!(t instanceof SQLException)) break block12;
                String state = ((SQLException)t).getSQLState();
                if (!INVALID_DB_STATES.contains(state)) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception tested by statusOnException() implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", t);
                }
                int n = -8;
                return n;
            }
            int n = this.activeCheckConnection(c, query, rootCauseOutParamHolder);
            return n;
        }
        try {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", t);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = t;
            }
            int state = -1;
            return state;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c + " failed Connection test with an Exception!", (Throwable)e);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e;
            }
            int n = -1;
            return n;
        }
    }

    private static String queryInfo(String query) {
        return query == null ? "[using default system-table query]" : "[query=" + query + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int activeCheckConnectionNoQuery(Connection c, Throwable[] rootCauseOutParamHolder) {
        int n;
        ResultSet rs = null;
        try {
            rs = c.getMetaData().getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
            n = 0;
        }
        catch (SQLException e) {
            block12: {
                String state;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + c + " failed default system-table Connection test with an Exception!", (Throwable)e);
                }
                if (rootCauseOutParamHolder != null) {
                    rootCauseOutParamHolder[0] = e;
                }
                if (!INVALID_DB_STATES.contains(state = e.getSQLState())) break block12;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", (Throwable)e);
                }
                int n2 = -8;
                ResultSetUtils.attemptClose((ResultSet)rs);
                return n2;
            }
            int n3 = -1;
            ResultSetUtils.attemptClose((ResultSet)rs);
            return n3;
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c + " failed default system-table Connection test with an Exception!", (Throwable)e2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e2;
            }
            int n4 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(rs);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose((ResultSet)rs);
            return n4;
        }
        ResultSetUtils.attemptClose((ResultSet)rs);
        return n;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == DefaultConnectionTester.class;
    }

    public int hashCode() {
        return HASH_CODE;
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("08001");
        temp.add("08007");
        INVALID_DB_STATES = Collections.unmodifiableSet(temp);
    }
}

