/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.Session;
import com.mks.api.commands.SICommands;
import com.mks.api.commands.ide.ISandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingDirectoryFactory;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileCache;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidItemException;
import com.mks.api.response.Item;
import com.mks.api.response.ItemNotFoundException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WorkingFileFactory {
    private static final String VIEWSANDBOX_FIELDS = "context,memberrev,workingrev,lockrecord,newrevdelta,revsyncdelta,wfdelta,workingcpid,locker,deferred";
    private static long ordinal = 0L;

    private WorkingFileFactory() {
    }

    private static WorkingFileCache getWorkingFileCache(SICommands si) {
        boolean retainedCache = !(si.getCmdRunnerCreator() instanceof Session);
        return WorkingFileCache.getInstance(retainedCache);
    }

    public static WorkingFile getWorkingFile(CmdRunnerCreator session, String fileName) {
        ArrayList<String> fileNames = new ArrayList<String>(1);
        fileNames.add(fileName);
        return (WorkingFile)WorkingFileFactory.getWorkingFiles(session, fileNames).getList().get(0);
    }

    public static WorkingFile refreshWorkingFile(CmdRunnerCreator session, String fileName) {
        ArrayList<String> fileNames = new ArrayList<String>(1);
        fileNames.add(fileName);
        return (WorkingFile)WorkingFileFactory.refreshWorkingFiles(session, fileNames).getList().get(0);
    }

    public static WorkingFileList getWorkingFiles(CmdRunnerCreator session, List fileNames) {
        return WorkingFileFactory.getWorkingFiles(session, fileNames, false);
    }

    private static WorkingFileList getWorkingFiles(CmdRunnerCreator session, List fileNames, boolean refresh) {
        WorkingFileList wfs;
        try {
            SICommands si = new SICommands(session, false);
            WorkingFileCache wfCache = WorkingFileFactory.getWorkingFileCache(si);
            if (refresh) {
                Iterator it = fileNames.iterator();
                while (it.hasNext()) {
                    wfCache.removeWorkingFile(new File((String)it.next()));
                }
            }
            wfs = WorkingFileFactory.getWorkingFiles(si, wfCache, fileNames);
        }
        catch (APIException apix) {
            wfs = WorkingFileFactory.invalidate(fileNames, new Date());
        }
        return wfs;
    }

    public static WorkingFileList refreshWorkingFiles(CmdRunnerCreator session, List fileNames) {
        return WorkingFileFactory.getWorkingFiles(session, fileNames, true);
    }

    public static WorkingFileList getWorkingFiles(SICommands si, List fileNames) {
        return WorkingFileFactory.getWorkingFiles(si, WorkingFileFactory.getWorkingFileCache(si), fileNames);
    }

    public static synchronized long getNewOrdinal() {
        return ordinal++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkingFileList getWorkingFiles(SICommands si, WorkingFileCache wfCache, List fileNames) {
        WorkingFile wf;
        String userId;
        Date timestamp = new Date();
        long ordinal = WorkingFileFactory.getNewOrdinal();
        HashMap dirMap = new HashMap();
        HashMap sandboxContentMap = new HashMap();
        HashMap sandboxBuckets = new HashMap();
        HashMap<File, Integer> indexMap = new HashMap<File, Integer>();
        ArrayList<WorkingFile> deferredMoves = new ArrayList<WorkingFile>();
        Object[] fileNameArray = fileNames.toArray();
        File[] files = new File[fileNameArray.length];
        WorkingFile[] wfArray = new WorkingFile[fileNameArray.length];
        for (int i = 0; i < fileNameArray.length; ++i) {
            File workingRoot;
            String fileName = (String)fileNameArray[i];
            files[i] = new File(fileName);
            indexMap.put(files[i], new Integer(i));
            WorkingFile wf2 = wfCache.getWorkingFile(files[i]);
            if (wf2 != null) {
                wfArray[i] = wf2;
                if (!wf2.isInvalid()) {
                    continue;
                }
            } else {
                wf2 = new WorkingFile(files[i], null, null, false, timestamp, ordinal);
                wf2.invalidate();
                wfArray[i] = wf2;
                wfCache.addWorkingFile(si.getCmdRunnerCreator(), wf2);
            }
            try {
                workingRoot = WorkingFileFactory.getWorkingRoot(si, files[i], dirMap, sandboxContentMap);
            }
            catch (APIException apix) {
                wfArray[i] = new WorkingFile(files[i], apix, timestamp, ordinal);
                continue;
            }
            if (workingRoot == null) {
                wfArray[i] = new WorkingFile(files[i], null, null, false, timestamp, ordinal);
                wfCache.addWorkingFile(si.getCmdRunnerCreator(), wfArray[i]);
                continue;
            }
            WorkingFileFactory.addToSbxBucket(workingRoot, files[i], sandboxBuckets);
        }
        Iterator workingRoots = sandboxBuckets.keySet().iterator();
        while (workingRoots != null && workingRoots.hasNext()) {
            WorkItem wi;
            File file;
            Iterator fileIterator;
            WorkItemIterator wis;
            File workingRoot = (File)workingRoots.next();
            List sbxFiles = (List)sandboxBuckets.get(workingRoot);
            ArrayList<File> diffFiles = new ArrayList<File>();
            boolean potentialDeferredRename = false;
            Response sbxView = null;
            sbxView = WorkingFileFactory.viewSandbox(si, workingRoot, sbxFiles, null);
            if (sbxView != null) {
                try {
                    wis = sbxView.getWorkItems();
                    userId = sbxView.getConnectionUsername();
                    fileIterator = sbxFiles.iterator();
                    while (fileIterator.hasNext() && wis.hasNext()) {
                        file = (File)fileIterator.next();
                        File sandbox = null;
                        int index = (Integer)indexMap.get(file);
                        try {
                            sandbox = WorkingFileFactory.getWorkingSandbox(si, file, dirMap, sandboxContentMap);
                            wi = wis.next();
                            String sandboxPath = null;
                            if (sandbox != null) {
                                sandboxPath = sandbox.getAbsolutePath();
                            }
                            wfArray[index] = wf = new WorkingFile(file, sandboxPath, workingRoot, wi, timestamp, userId, ordinal);
                            if (wf.isMoved()) {
                                potentialDeferredRename = true;
                                if (indexMap.containsKey(wf.getFile())) continue;
                                indexMap.put(wf.getFile(), new Integer(index));
                                files[index] = wf.getFile();
                                continue;
                            }
                            if (!wf.hasWorkingDelta() || wf.isModified()) continue;
                            diffFiles.add(file);
                        }
                        catch (ItemNotFoundException infx) {
                            WorkingFile wf3;
                            if (sandbox == null) {
                                wf3 = new WorkingFile(file, infx, timestamp, ordinal);
                            } else if (file.equals(sandbox)) {
                                wf3 = new WorkingFile(file, sandbox.getAbsolutePath(), workingRoot, true, timestamp, ordinal);
                            } else {
                                WorkItem wi2 = wis.getLast();
                                File nonMemberRoot = null;
                                try {
                                    WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, workingRoot, dirMap);
                                    if (wd.isSandboxAware() && !wd.isAmbiguous()) {
                                        nonMemberRoot = workingRoot;
                                    }
                                }
                                catch (APIException ignored) {
                                    // empty catch block
                                }
                                wf3 = new WorkingFile(file, sandbox.getAbsolutePath(), nonMemberRoot, wi2, timestamp, userId, ordinal);
                                if (!wf3.isFormerMember()) {
                                    potentialDeferredRename = true;
                                }
                            }
                            wfArray[index] = wf3;
                        }
                        catch (APIException apix) {
                            wfArray[index] = new WorkingFile(file, apix, timestamp, ordinal);
                        }
                    }
                }
                finally {
                    try {
                        sbxView.release();
                    }
                    catch (APIException ignored) {}
                }
            }
            if (!diffFiles.isEmpty()) {
                APIException ignored3;
                Object var34_56;
                Response diff = WorkingFileFactory.diffStatus(si, workingRoot, diffFiles);
                try {
                    wis = diff != null ? diff.getWorkItems() : null;
                    fileIterator = diffFiles.iterator();
                    while (fileIterator.hasNext()) {
                        file = (File)fileIterator.next();
                        int index = (Integer)indexMap.get(file);
                        boolean modified = true;
                        if (wis != null) {
                            try {
                                wi = wis.next();
                                Item result = wi.getResult().getPrimaryValue();
                                Field status = result.getField("different");
                                modified = status.getBoolean();
                            }
                            catch (Throwable ignored2) {
                                // empty catch block
                            }
                        }
                        if (!modified) continue;
                        wfArray[index].markModified();
                    }
                    var34_56 = null;
                }
                catch (Throwable throwable) {
                    var34_56 = null;
                    try {
                        if (diff != null) {
                            diff.release();
                        }
                    }
                    catch (APIException ignored3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (diff != null) {
                        diff.release();
                    }
                }
                catch (APIException ignored3) {}
            }
            if (!potentialDeferredRename) continue;
            OptionList options = new OptionList();
            options.add(new Option("filterSubs"));
            options.add("filter", "deferred:move,deferred:rename");
            options.add(new Option("recurse"));
            sbxView = WorkingFileFactory.viewSandbox(si, workingRoot, null, options);
            if (sbxView == null) continue;
            String userId2 = sbxView.getConnectionUsername();
            wis = sbxView.getWorkItems();
            while (wis.hasNext()) {
                try {
                    Integer indexMarker;
                    File sandbox;
                    WorkingFile wf4;
                    String fileName;
                    WorkItem wi3 = wis.next();
                    if (wi3.getModelType() == null) continue;
                    boolean isDestinedMember = wi3.getModelType().equals("si.DestinedMember");
                    boolean isMember = wi3.getModelType().equals("si.Member");
                    if (!isDestinedMember && !isMember || (fileName = wi3.getField("name").getString()) == null) continue;
                    File file2 = new File(fileName);
                    File myWorkingRoot = workingRoot;
                    if (isDestinedMember) {
                        File canonicalSandbox = new File(wi3.getField("canonicalSandbox").getString());
                        myWorkingRoot = WorkingFileFactory.getWorkingRoot(si, canonicalSandbox, dirMap, sandboxContentMap);
                    }
                    if (!(wf4 = new WorkingFile(file2, (sandbox = WorkingFileFactory.getWorkingSandbox(si, file2, dirMap, sandboxContentMap)).getAbsolutePath(), myWorkingRoot, wi3, timestamp, userId2, ordinal)).isMoved() || (indexMarker = (Integer)indexMap.get(file2)) == null) continue;
                    int index = indexMarker;
                    if (wfArray[index].isModified()) {
                        wf4.markModified();
                    }
                    wfArray[index] = wf4;
                    WorkingFileFactory.getWorkingRoot(si, wf4.getMemberName(), dirMap, sandboxContentMap);
                    if (!isDestinedMember || !wf4.isMoved()) continue;
                    deferredMoves.add(wf4);
                }
                catch (APIException apix) {}
            }
        }
        WorkingFileList deferredMoveWFList = new WorkingFileList();
        Iterator mv = deferredMoves.iterator();
        while (mv.hasNext()) {
            deferredMoveWFList.add((WorkingFile)mv.next());
        }
        Map deferredMoveSandboxBuckets = deferredMoveWFList.getWorkingFileBuckets();
        Iterator deferredMoveSandboxes = deferredMoveSandboxBuckets.keySet().iterator();
        while (deferredMoveSandboxes.hasNext()) {
            File workingRoot = (File)deferredMoveSandboxes.next();
            WorkingFileList sbxWorkingFiles = (WorkingFileList)deferredMoveSandboxBuckets.get(workingRoot);
            Response sbxView = null;
            sbxView = WorkingFileFactory.viewSandbox(si, workingRoot, sbxWorkingFiles.getMemberList(), null);
            if (sbxView == null) continue;
            try {
                userId = sbxView.getConnectionUsername();
                WorkItemIterator wis = sbxView.getWorkItems();
                Iterator workingFileIterator = sbxWorkingFiles.iterator();
                while (workingFileIterator.hasNext() && wis.hasNext()) {
                    WorkingFile movedWorkingFile = (WorkingFile)workingFileIterator.next();
                    int index = (Integer)indexMap.get(movedWorkingFile.getFile());
                    try {
                        WorkItem wi = wis.next();
                        wf = new WorkingFile(movedWorkingFile.getFile(), movedWorkingFile.getSandbox(), workingRoot, wi, timestamp, userId, ordinal);
                        if (wfArray[index].isModified()) {
                            wf.markModified();
                        }
                        wfArray[index] = wf;
                    }
                    catch (APIException apix) {
                        wfArray[index] = new WorkingFile(movedWorkingFile.getFile(), apix, timestamp, ordinal);
                    }
                }
            }
            finally {
                try {
                    sbxView.release();
                }
                catch (APIException ignored) {}
            }
        }
        for (int i = 0; i < wfArray.length; ++i) {
            if (wfArray[i] == null) {
                wfArray[i] = new WorkingFile(files[i], new InvalidItemException(), timestamp, ordinal);
            }
            wfCache.addWorkingFile(si.getCmdRunnerCreator(), wfArray[i]);
            WorkingFile cachedWF = wfCache.getWorkingFile(wfArray[i].getFile());
            if (cachedWF.isInvalid()) continue;
            wfArray[i] = cachedWF;
        }
        WorkingFileList list = new WorkingFileList(wfArray);
        return list;
    }

    private static File getLocation(File filePath) {
        if (!filePath.isAbsolute()) {
            filePath = filePath.getAbsoluteFile();
        }
        if (!filePath.isDirectory()) {
            filePath = filePath.getParentFile();
        }
        return filePath;
    }

    private static File getWorkingRoot(SICommands si, File element, Map dirMap, Map sandboxContentMap) throws APIException {
        File root = null;
        WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, element, dirMap);
        if (!wd.isSandboxAware()) {
            root = null;
        } else if (!wd.isAmbiguous()) {
            ISandboxInfo sandbox = (ISandboxInfo)wd.getSandboxes().iterator().next();
            String parent = sandbox.getParentName();
            if (parent != null && !(root = WorkingFileFactory.getWorkingRoot(si, new File(parent), dirMap, sandboxContentMap)).isDirectory()) {
                parent = null;
            }
            if (parent == null) {
                root = sandbox.getSandboxLocation();
            }
        } else {
            root = WorkingFileFactory.getWorkingSandbox(si, element, dirMap, sandboxContentMap);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getWorkingSandbox(SICommands si, File element, Map dirMap, Map sandboxContentMap) throws APIException {
        ISandboxInfo sandbox;
        WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, element, dirMap);
        if (!wd.isSandboxAware()) {
            return null;
        }
        if (!wd.isAmbiguous()) {
            ISandboxInfo sandbox2 = (ISandboxInfo)wd.getSandboxes().iterator().next();
            return sandbox2.getSandboxFile();
        }
        File sandboxFile = null;
        Iterator sbxs = wd.getSandboxes().iterator();
        while (sbxs.hasNext() && !(sandboxFile = (sandbox = (ISandboxInfo)sbxs.next()).getSandboxFile()).equals(element)) {
            HashSet<File> content = (HashSet<File>)sandboxContentMap.get(sandboxFile);
            if (content == null) {
                Response sbxView = WorkingFileFactory.viewSandbox(si, sandboxFile, null, null);
                content = new HashSet<File>();
                if (sbxView != null) {
                    try {
                        WorkItemIterator i = sbxView.getWorkItems();
                        while (i.hasNext()) {
                            WorkItem wi = null;
                            try {
                                wi = i.next();
                            }
                            catch (APIException ignored) {
                                wi = i.getLast();
                            }
                            File wiFile = new File(wi.getId());
                            if (!wiFile.isAbsolute()) {
                                wiFile = new File(sandboxFile.getParentFile(), wi.getId());
                            }
                            content.add(wiFile);
                        }
                        if (sbxView.getAPIException() != null) {
                            throw sbxView.getAPIException();
                        }
                    }
                    finally {
                        try {
                            sbxView.release();
                        }
                        catch (APIException ignored) {}
                    }
                }
                sandboxContentMap.put(sandboxFile, content);
            }
            if (!content.contains(element)) continue;
            break;
        }
        return sandboxFile;
    }

    private static WorkingDirectory getWorkingDirectory(SICommands si, File element, Map dirMap) throws APIException {
        WorkingDirectory wd = null;
        File path = WorkingFileFactory.getLocation(element);
        if (dirMap.containsKey(path)) {
            wd = (WorkingDirectory)dirMap.get(path);
        }
        if (wd == null) {
            wd = WorkingDirectoryFactory.getWorkingDirectory(si.getCmdRunnerCreator(), path);
            dirMap.put(path, wd);
        }
        return wd;
    }

    private static void addToSbxBucket(File root, File file, Map sandboxBuckets) {
        List<File> bucket = null;
        if (sandboxBuckets.containsKey(root)) {
            bucket = (List)sandboxBuckets.get(root);
            bucket.add(file);
        } else {
            bucket = new ArrayList();
            bucket.add(file);
            sandboxBuckets.put(root, bucket);
        }
    }

    private static String[] memberNames(Collection members) {
        String[] memberNames;
        if (members == null) {
            memberNames = null;
        } else {
            memberNames = new String[members.size()];
            Iterator i = members.iterator();
            int j = 0;
            while (i.hasNext()) {
                File member = (File)i.next();
                memberNames[j] = member.getAbsolutePath();
                ++j;
            }
        }
        return memberNames;
    }

    private static Response viewSandbox(SICommands si, File sandboxRoot, List members, OptionList options) {
        Response r;
        File sandboxDir = WorkingFileFactory.getLocation(sandboxRoot);
        OptionList viewOptions = new OptionList();
        viewOptions.add(new Option("fields", VIEWSANDBOX_FIELDS));
        viewOptions.add(new Option("norecurse"));
        if (!sandboxRoot.isDirectory()) {
            viewOptions.add(new Option("sandbox", sandboxRoot.getAbsolutePath()));
        }
        if (options != null) {
            Iterator it = options.getOptions();
            while (it.hasNext()) {
                viewOptions.add((Option)it.next());
            }
        }
        try {
            String cwdPath = sandboxDir.getAbsolutePath();
            r = si.getSandboxMemberStatus(cwdPath, WorkingFileFactory.memberNames(members), viewOptions, true);
        }
        catch (APIException apix) {
            r = apix.getResponse();
        }
        return r;
    }

    private static Response diffStatus(SICommands si, File workingRoot, List members) {
        Response r;
        try {
            OptionList options = null;
            String cwdPath = null;
            if (workingRoot != null) {
                cwdPath = WorkingFileFactory.getLocation(workingRoot).getAbsolutePath();
                if (!workingRoot.isDirectory()) {
                    options = new OptionList();
                    options.add(new Option("sandbox", workingRoot.getAbsolutePath()));
                }
            }
            r = si.getSandboxMemberDifferenceStatus(cwdPath, WorkingFileFactory.memberNames(members), options);
        }
        catch (APIException apix) {
            r = apix.getResponse();
        }
        return r;
    }

    private static WorkingFileList invalidate(List fileNames, Date timestamp) {
        WorkingFile[] wfArray = new WorkingFile[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            wfArray[i] = new WorkingFile((File)fileNames.get(i), new InvalidItemException(), timestamp, WorkingFileFactory.getNewOrdinal());
        }
        return new WorkingFileList(wfArray);
    }

    static boolean isWin32() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }
}

