/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.filter;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.gateway.context.GatewayStrategyContext;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyFilterResolver;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.gateway.monitor.GatewayStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractGatewayStrategyRouteFilter
implements GatewayStrategyRouteFilter {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyWrapper strategyWrapper;
    @Autowired(required=false)
    protected GatewayStrategyMonitor gatewayStrategyMonitor;
    @Value(value="${spring.application.strategy.gateway.header.priority:true}")
    protected Boolean gatewayHeaderPriority;
    @Value(value="${spring.application.strategy.gateway.original.header.ignored:true}")
    protected Boolean gatewayOriginalHeaderIgnored;
    @Value(value="${spring.application.strategy.gateway.core.header.transmission.enabled:true}")
    protected Boolean gatewayCoreHeaderTransmissionEnabled;
    @Value(value="${spring.application.strategy.gateway.route.filter.order:9000}")
    protected Integer filterOrder;

    public int getOrder() {
        return this.filterOrder;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String path;
        GatewayStrategyContext.getCurrentContext().setExchange(exchange);
        ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
        String routeEnvironment = this.getRouteEnvironment();
        if (StringUtils.isNotEmpty((CharSequence)routeEnvironment)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-env", routeEnvironment, false);
        }
        if (this.gatewayCoreHeaderTransmissionEnabled.booleanValue()) {
            Map headerMap = this.strategyWrapper.getHeaderMap();
            if (MapUtils.isNotEmpty((Map)headerMap)) {
                for (Map.Entry entry : headerMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    GatewayStrategyFilterResolver.setHeader(requestBuilder, key, value, this.gatewayHeaderPriority);
                }
            }
            String routeVersion = this.getRouteVersion();
            String routeRegion = this.getRouteRegion();
            String routeAddress = this.getRouteAddress();
            String routeVersionWeight = this.getRouteVersionWeight();
            String routeRegionWeight = this.getRouteRegionWeight();
            String routeIdBlacklist = this.getRouteIdBlacklist();
            String routeAddressBlacklist = this.getRouteAddressBlacklist();
            if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-version", routeVersion, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegion)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-region", routeRegion, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddress)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-address", routeAddress, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeVersionWeight)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-version-weight", routeVersionWeight, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegionWeight)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-region-weight", routeRegionWeight, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeIdBlacklist)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-id-blacklist", routeIdBlacklist, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-id-blacklist", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddressBlacklist)) {
                GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-address-blacklist", routeAddressBlacklist, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-blacklist", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-weight");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-weight");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-id-blacklist");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-blacklist");
        }
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-group", this.pluginAdapter.getGroup(), this.gatewayHeaderPriority);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-type", this.pluginAdapter.getServiceType(), false);
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-app-id", serviceAppId, false);
        }
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-id", this.pluginAdapter.getServiceId(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-version", this.pluginAdapter.getVersion(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-region", this.pluginAdapter.getRegion(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-env", this.pluginAdapter.getEnvironment(), false);
        GatewayStrategyFilterResolver.setHeader(requestBuilder, "n-d-service-zone", this.pluginAdapter.getZone(), false);
        ServerHttpRequest newRequest = requestBuilder.build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        ServerWebExchange extensionExchange = this.extendFilter(newExchange, chain);
        ServerWebExchange finalExchange = extensionExchange != null ? extensionExchange : newExchange;
        GatewayStrategyContext.getCurrentContext().setExchange(newExchange);
        if (this.gatewayStrategyMonitor != null) {
            this.gatewayStrategyMonitor.monitor(finalExchange);
        }
        if ((path = finalExchange.getRequest().getPath().toString()).contains("/inspector/inspect")) {
            GatewayStrategyFilterResolver.setHeader(requestBuilder, "endpoint-inspector-inspect", this.pluginAdapter.getPluginInfo(null), true);
        }
        return chain.filter(finalExchange);
    }

    protected ServerWebExchange extendFilter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return null;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }
}

