/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.condition;

import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionStrategyResolver {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();

    public static boolean eval(String expression, String key, Map<String, String> map, TypeComparator typeComparator) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setTypeComparator(typeComparator);
        context.setVariable(key, map);
        return ExpressionStrategyResolver.eval(expression, context);
    }

    public static boolean eval(String expression, Map<String, Map<String, String>> map, TypeComparator typeComparator) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setTypeComparator(typeComparator);
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
        }
        return ExpressionStrategyResolver.eval(expression, context);
    }

    public static boolean eval(String expression, StandardEvaluationContext context) {
        try {
            Boolean result = (Boolean)EXPRESSION_PARSER.parseExpression(expression).getValue((EvaluationContext)context, Boolean.class);
            return result != null ? result : false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

