/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.strategy.adapter.StrategyVersionFilterAdapter;
import com.nepxion.discovery.plugin.strategy.matcher.DiscoveryMatcherStrategy;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class StrategyVersionFilter {
    @Autowired
    private DiscoveryMatcherStrategy discoveryMatcherStrategy;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected PluginContextHolder pluginContextHolder;
    @Autowired
    protected StrategyVersionFilterAdapter strategyVersionFilterAdapter;
    @Autowired
    protected DiscoveryClient discoveryClient;
    @Value(value="${spring.application.environment.route:common}")
    protected String environmentRoute;

    public boolean apply(Server server) {
        String version = this.pluginAdapter.getServerVersion(server);
        if (StringUtils.equals((String)version, (String)"default")) {
            return true;
        }
        List<String> versionList = this.getVersionList(server);
        if (versionList.size() <= 1) {
            return true;
        }
        List<String> filterVersionList = this.strategyVersionFilterAdapter.filter(versionList);
        return filterVersionList.contains(version);
    }

    private List<String> getVersionList(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        List instances = this.discoveryClient.getInstances(serviceId);
        ArrayList<String> versionList = new ArrayList<String>();
        for (ServiceInstance instance : instances) {
            String version = this.pluginAdapter.getInstanceVersion(instance);
            if (versionList.contains(version) || StringUtils.equals((String)version, (String)"default") || !this.applyEnvironment(instance) || !this.applyRegion(instance) || !this.applyAddress(instance) || !this.applyIdBlacklist(instance) || !this.applyAddressBlacklist(instance)) continue;
            versionList.add(version);
        }
        if (versionList.size() > 1) {
            Collections.sort(versionList);
        }
        return versionList;
    }

    public boolean applyEnvironment(ServiceInstance instance) {
        String environmentValue = this.pluginContextHolder.getContextRouteEnvironment();
        if (StringUtils.isEmpty((String)environmentValue)) {
            return true;
        }
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        List instances = this.discoveryClient.getInstances(serviceId);
        boolean matched = false;
        for (ServiceInstance serviceInstance : instances) {
            String instanceEnvironment = this.pluginAdapter.getInstanceEnvironment(serviceInstance);
            if (!StringUtils.equals((String)environmentValue, (String)instanceEnvironment)) continue;
            matched = true;
            break;
        }
        String environment = this.pluginAdapter.getInstanceEnvironment(instance);
        if (matched) {
            return StringUtils.equals((String)environment, (String)environmentValue);
        }
        return StringUtils.equals((String)environment, (String)this.environmentRoute) || StringUtils.equals((String)environment, (String)"default");
    }

    public boolean applyRegion(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String regions = this.getRegions(serviceId);
        if (StringUtils.isEmpty((String)regions)) {
            return true;
        }
        String region = this.pluginAdapter.getInstanceRegion(instance);
        List regionList = StringUtil.splitToList((String)regions, (String)";");
        if (regionList.contains(region)) {
            return true;
        }
        for (String regionPattern : regionList) {
            if (!this.discoveryMatcherStrategy.match(regionPattern, region)) continue;
            return true;
        }
        return false;
    }

    public String getRegions(String serviceId) {
        String regionValue = this.pluginContextHolder.getContextRouteRegion();
        if (StringUtils.isEmpty((String)regionValue)) {
            return null;
        }
        String regions = null;
        try {
            Map regionMap = (Map)JsonUtil.fromJson((String)regionValue, Map.class);
            regions = (String)regionMap.get(serviceId);
        }
        catch (Exception e) {
            regions = regionValue;
        }
        return regions;
    }

    public boolean applyAddress(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String addresses = this.getAddresses(serviceId);
        if (StringUtils.isEmpty((String)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses, (String)";");
        if (addressList.contains(instance.getHost() + ":" + instance.getPort()) || addressList.contains(instance.getHost()) || addressList.contains(String.valueOf(instance.getPort()))) {
            return true;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, instance.getHost() + ":" + instance.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, instance.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(instance.getPort()))) continue;
            return true;
        }
        return false;
    }

    public String getAddresses(String serviceId) {
        String addressValue = this.pluginContextHolder.getContextRouteAddress();
        if (StringUtils.isEmpty((String)addressValue)) {
            return null;
        }
        String addresses = null;
        try {
            Map addressMap = (Map)JsonUtil.fromJson((String)addressValue, Map.class);
            addresses = (String)addressMap.get(serviceId);
        }
        catch (Exception e) {
            addresses = addressValue;
        }
        return addresses;
    }

    public boolean applyIdBlacklist(ServiceInstance instance) {
        String ids = this.pluginContextHolder.getContextRouteIdBlacklist();
        if (StringUtils.isEmpty((String)ids)) {
            return true;
        }
        String serviceUUId = this.pluginAdapter.getInstanceServiceUUId(instance);
        List idList = StringUtil.splitToList((String)ids, (String)";");
        return !idList.contains(serviceUUId);
    }

    public boolean applyAddressBlacklist(ServiceInstance instance) {
        String addresses = this.pluginContextHolder.getContextRouteAddressBlacklist();
        if (StringUtils.isEmpty((String)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses, (String)";");
        if (addressList.contains(instance.getHost() + ":" + instance.getPort()) || addressList.contains(instance.getHost()) || addressList.contains(String.valueOf(instance.getPort()))) {
            return false;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, instance.getHost() + ":" + instance.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, instance.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(instance.getPort()))) continue;
            return false;
        }
        return true;
    }

    public boolean applyVersion(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String versions = this.getVersions(serviceId);
        if (StringUtils.isEmpty((String)versions)) {
            return true;
        }
        String version = this.pluginAdapter.getInstanceVersion(instance);
        List versionList = StringUtil.splitToList((String)versions, (String)";");
        if (versionList.contains(version)) {
            return true;
        }
        for (String versionPattern : versionList) {
            if (!this.discoveryMatcherStrategy.match(versionPattern, version)) continue;
            return true;
        }
        return false;
    }

    public String getVersions(String serviceId) {
        String versionValue = this.pluginContextHolder.getContextRouteVersion();
        if (StringUtils.isEmpty((String)versionValue)) {
            return null;
        }
        String versions = null;
        try {
            Map versionMap = (Map)JsonUtil.fromJson((String)versionValue, Map.class);
            versions = (String)versionMap.get(serviceId);
        }
        catch (Exception e) {
            versions = versionValue;
        }
        return versions;
    }
}

