/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.isolation;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.event.RegisterFailureEvent;
import com.nepxion.discovery.plugin.framework.listener.register.AbstractRegisterListener;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.serviceregistry.Registration;

public class ConsumerIsolationRegisterStrategy
extends AbstractRegisterListener {
    public void onRegister(Registration registration) {
        List<String> groupWhitelist;
        String serviceId = this.pluginAdapter.getServiceId();
        String host = this.pluginAdapter.getHost();
        int port = this.pluginAdapter.getPort();
        String group = this.pluginAdapter.getGroup();
        List<String> groupBlacklist = this.getGroupBlacklist();
        if (CollectionUtils.isNotEmpty(groupBlacklist) && groupBlacklist.contains(group)) {
            this.onRegisterFailure(group, serviceId, host, port, true);
        }
        if (CollectionUtils.isNotEmpty(groupWhitelist = this.getGroupWhitelist()) && !groupWhitelist.contains(group)) {
            this.onRegisterFailure(group, serviceId, host, port, false);
        }
    }

    protected List<String> getGroupBlacklist() {
        String groupBlacklistText = (String)this.pluginContextAware.getEnvironment().getProperty("spring.application.strategy.register.isolation.group.blacklist", String.class, null);
        if (StringUtils.isEmpty((CharSequence)groupBlacklistText)) {
            return null;
        }
        return StringUtil.splitToList((String)groupBlacklistText, (String)";");
    }

    protected List<String> getGroupWhitelist() {
        String groupWhitelistText = (String)this.pluginContextAware.getEnvironment().getProperty("spring.application.strategy.register.isolation.group.whitelist", String.class, null);
        if (StringUtils.isEmpty((CharSequence)groupWhitelistText)) {
            return null;
        }
        return StringUtil.splitToList((String)groupWhitelistText, (String)";");
    }

    private void onRegisterFailure(String group, String serviceId, String host, int port, boolean isBlacklist) {
        String description = serviceId + " for " + host + ":" + port + " is rejected to register to Register server, it's group=" + group;
        description = isBlacklist ? description + " is in isolation blacklist" : description + " isn't in isolation whitelist";
        this.pluginEventWapper.fireRegisterFailure(new RegisterFailureEvent("register isolation", description, serviceId, host, port));
        throw new DiscoveryException(description);
    }

    public void onDeregister(Registration registration) {
    }

    public void onSetStatus(Registration registration, String status) {
    }

    public void onClose() {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

