/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.wrapper;

import com.nepxion.discovery.common.entity.AddressWeightEntity;
import com.nepxion.discovery.common.entity.MapWeightEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyBlacklistEntity;
import com.nepxion.discovery.common.entity.StrategyConditionBlueGreenEntity;
import com.nepxion.discovery.common.entity.StrategyConditionEntity;
import com.nepxion.discovery.common.entity.StrategyConditionGrayEntity;
import com.nepxion.discovery.common.entity.StrategyCustomizationEntity;
import com.nepxion.discovery.common.entity.StrategyEntity;
import com.nepxion.discovery.common.entity.StrategyHeaderEntity;
import com.nepxion.discovery.common.entity.StrategyRouteEntity;
import com.nepxion.discovery.common.entity.StrategyRouteType;
import com.nepxion.discovery.common.entity.VersionWeightEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.MapWeightRandom;
import com.nepxion.discovery.plugin.strategy.condition.StrategyCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.factory.annotation.Autowired;

public class StrategyWrapper {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyCondition strategyCondition;

    public String getRouteVersion() {
        return this.getRouteVersion(null);
    }

    public String getRouteRegion() {
        return this.getRouteRegion(null);
    }

    public String getRouteAddress() {
        return this.getRouteAddress(null);
    }

    public String getRouteVersionWeight() {
        return this.getRouteVersionWeight(null);
    }

    public String getRouteRegionWeight() {
        return this.getRouteRegionWeight(null);
    }

    public String getRouteIdBlacklist() {
        StrategyBlacklistEntity strategyBlacklistEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyBlacklistEntity = ruleEntity.getStrategyBlacklistEntity()) != null) {
            return strategyBlacklistEntity.toIds();
        }
        return null;
    }

    public String getRouteAddressBlacklist() {
        StrategyBlacklistEntity strategyBlacklistEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyBlacklistEntity = ruleEntity.getStrategyBlacklistEntity()) != null) {
            return strategyBlacklistEntity.toAddresses();
        }
        return null;
    }

    public String getRouteVersion(Map<String, String> headerMap) {
        String routeVersion = this.getConditionBlueGreenRouteVersion(headerMap);
        if (StringUtils.isEmpty((CharSequence)routeVersion) && StringUtils.isEmpty((CharSequence)(routeVersion = this.getConditionGrayRouteVersion(headerMap)))) {
            routeVersion = this.getGlobalRouteVersion();
        }
        return routeVersion;
    }

    public String getRouteRegion(Map<String, String> headerMap) {
        String routeRegion = this.getConditionBlueGreenRouteRegion(headerMap);
        if (StringUtils.isEmpty((CharSequence)routeRegion) && StringUtils.isEmpty((CharSequence)(routeRegion = this.getConditionGrayRouteRegion(headerMap)))) {
            routeRegion = this.getGlobalRouteRegion();
        }
        return routeRegion;
    }

    public String getRouteAddress(Map<String, String> headerMap) {
        String routeAddress = this.getConditionBlueGreenRouteAddress(headerMap);
        if (StringUtils.isEmpty((CharSequence)routeAddress) && StringUtils.isEmpty((CharSequence)(routeAddress = this.getConditionGrayRouteAddress(headerMap)))) {
            routeAddress = this.getGlobalRouteAddress();
        }
        return routeAddress;
    }

    public String getRouteVersionWeight(Map<String, String> headerMap) {
        String routeVersionWeight = this.getConditionBlueGreenRouteVersionWeight(headerMap);
        if (StringUtils.isEmpty((CharSequence)routeVersionWeight)) {
            routeVersionWeight = this.getGlobalRouteVersionWeight();
        }
        return routeVersionWeight;
    }

    public String getRouteRegionWeight(Map<String, String> headerMap) {
        String routeRegionWeight = this.getConditionBlueGreenRouteRegionWeight(headerMap);
        if (StringUtils.isEmpty((CharSequence)routeRegionWeight)) {
            routeRegionWeight = this.getGlobalRouteRegionWeight();
        }
        return routeRegionWeight;
    }

    public String getGlobalRouteVersion() {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            return strategyEntity.getVersionValue();
        }
        return null;
    }

    public String getGlobalRouteRegion() {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            return strategyEntity.getRegionValue();
        }
        return null;
    }

    public String getGlobalRouteAddress() {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            return strategyEntity.getAddressValue();
        }
        return null;
    }

    public String getGlobalRouteVersionWeight() {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            return strategyEntity.getVersionWeightValue();
        }
        return null;
    }

    public String getGlobalRouteRegionWeight() {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            return strategyEntity.getRegionWeightValue();
        }
        return null;
    }

    public String getConditionBlueGreenRouteVersion(Map<String, String> headerMap) {
        String versionId;
        StrategyRouteEntity strategyRouteEntity;
        StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = this.getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType.VERSION, headerMap);
        if (strategyConditionBlueGreenEntity != null && (strategyRouteEntity = this.getTriggeredStrategyRouteEntity(versionId = strategyConditionBlueGreenEntity.getVersionId(), StrategyRouteType.VERSION)) != null) {
            return strategyRouteEntity.getValue();
        }
        return null;
    }

    public String getConditionBlueGreenRouteRegion(Map<String, String> headerMap) {
        String regionId;
        StrategyRouteEntity strategyRouteEntity;
        StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = this.getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType.REGION, headerMap);
        if (strategyConditionBlueGreenEntity != null && (strategyRouteEntity = this.getTriggeredStrategyRouteEntity(regionId = strategyConditionBlueGreenEntity.getRegionId(), StrategyRouteType.REGION)) != null) {
            return strategyRouteEntity.getValue();
        }
        return null;
    }

    public String getConditionBlueGreenRouteAddress(Map<String, String> headerMap) {
        String addressId;
        StrategyRouteEntity strategyRouteEntity;
        StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = this.getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType.ADDRESS, headerMap);
        if (strategyConditionBlueGreenEntity != null && (strategyRouteEntity = this.getTriggeredStrategyRouteEntity(addressId = strategyConditionBlueGreenEntity.getAddressId(), StrategyRouteType.ADDRESS)) != null) {
            return strategyRouteEntity.getValue();
        }
        return null;
    }

    public String getConditionBlueGreenRouteVersionWeight(Map<String, String> headerMap) {
        String versionWeightId;
        StrategyRouteEntity strategyRouteEntity;
        StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = this.getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType.VERSION_WEIGHT, headerMap);
        if (strategyConditionBlueGreenEntity != null && (strategyRouteEntity = this.getTriggeredStrategyRouteEntity(versionWeightId = strategyConditionBlueGreenEntity.getVersionWeightId(), StrategyRouteType.VERSION_WEIGHT)) != null) {
            return strategyRouteEntity.getValue();
        }
        return null;
    }

    public String getConditionBlueGreenRouteRegionWeight(Map<String, String> headerMap) {
        String regionWeightId;
        StrategyRouteEntity strategyRouteEntity;
        StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = this.getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType.REGION_WEIGHT, headerMap);
        if (strategyConditionBlueGreenEntity != null && (strategyRouteEntity = this.getTriggeredStrategyRouteEntity(regionWeightId = strategyConditionBlueGreenEntity.getRegionWeightId(), StrategyRouteType.REGION_WEIGHT)) != null) {
            return strategyRouteEntity.getValue();
        }
        return null;
    }

    private StrategyConditionBlueGreenEntity getTriggeredStrategyConditionBlueGreenEntity(StrategyRouteType strategyRouteType, Map<String, String> headerMap) {
        StrategyConditionBlueGreenEntity expressionStrategyConditionBlueGreenEntity;
        List strategyConditionBlueGreenEntityList;
        StrategyCustomizationEntity strategyCustomizationEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && CollectionUtils.isNotEmpty((Collection)(strategyConditionBlueGreenEntityList = strategyCustomizationEntity.getStrategyConditionBlueGreenEntityList())) && (expressionStrategyConditionBlueGreenEntity = this.getTriggeredExpressionStrategyConditionBlueGreenEntity(strategyConditionBlueGreenEntityList, strategyRouteType, headerMap)) != null) {
            return expressionStrategyConditionBlueGreenEntity;
        }
        return null;
    }

    private StrategyConditionBlueGreenEntity getTriggeredExpressionStrategyConditionBlueGreenEntity(List<StrategyConditionBlueGreenEntity> strategyConditionBlueGreenEntityList, StrategyRouteType strategyRouteType, Map<String, String> headerMap) {
        for (StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity : strategyConditionBlueGreenEntityList) {
            boolean isValidated = this.validateBlueGreenStrategyType(strategyConditionBlueGreenEntity, strategyRouteType);
            if (!isValidated) continue;
            boolean isTriggered = false;
            isTriggered = headerMap == null ? this.strategyCondition.isTriggered((StrategyConditionEntity)strategyConditionBlueGreenEntity) : this.strategyCondition.isTriggered((StrategyConditionEntity)strategyConditionBlueGreenEntity, headerMap);
            if (!isTriggered) continue;
            return strategyConditionBlueGreenEntity;
        }
        return null;
    }

    private boolean validateBlueGreenStrategyType(StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity, StrategyRouteType strategyRouteType) {
        switch (strategyRouteType) {
            case VERSION: {
                return StringUtils.isNotEmpty((CharSequence)strategyConditionBlueGreenEntity.getVersionId());
            }
            case REGION: {
                return StringUtils.isNotEmpty((CharSequence)strategyConditionBlueGreenEntity.getRegionId());
            }
            case ADDRESS: {
                return StringUtils.isNotEmpty((CharSequence)strategyConditionBlueGreenEntity.getAddressId());
            }
            case VERSION_WEIGHT: {
                return StringUtils.isNotEmpty((CharSequence)strategyConditionBlueGreenEntity.getVersionWeightId());
            }
            case REGION_WEIGHT: {
                return StringUtils.isNotEmpty((CharSequence)strategyConditionBlueGreenEntity.getRegionWeightId());
            }
            case ID_BLACKLIST: {
                break;
            }
        }
        return false;
    }

    public String getConditionGrayRouteVersion(Map<String, String> headerMap) {
        VersionWeightEntity versionWeightEntity;
        StrategyConditionGrayEntity strategyConditionGrayEntity = this.getTriggeredStrategyConditionGrayEntity(headerMap);
        if (strategyConditionGrayEntity != null && (versionWeightEntity = strategyConditionGrayEntity.getVersionWeightEntity()) != null) {
            return this.getTriggeredStrategyGrayRoute((MapWeightEntity)versionWeightEntity, StrategyRouteType.VERSION);
        }
        return null;
    }

    public String getConditionGrayRouteRegion(Map<String, String> headerMap) {
        RegionWeightEntity regionWeightEntity;
        StrategyConditionGrayEntity strategyConditionGrayEntity = this.getTriggeredStrategyConditionGrayEntity(headerMap);
        if (strategyConditionGrayEntity != null && (regionWeightEntity = strategyConditionGrayEntity.getRegionWeightEntity()) != null) {
            return this.getTriggeredStrategyGrayRoute((MapWeightEntity)regionWeightEntity, StrategyRouteType.REGION);
        }
        return null;
    }

    public String getConditionGrayRouteAddress(Map<String, String> headerMap) {
        AddressWeightEntity addressWeightEntity;
        StrategyConditionGrayEntity strategyConditionGrayEntity = this.getTriggeredStrategyConditionGrayEntity(headerMap);
        if (strategyConditionGrayEntity != null && (addressWeightEntity = strategyConditionGrayEntity.getAddressWeightEntity()) != null) {
            return this.getTriggeredStrategyGrayRoute((MapWeightEntity)addressWeightEntity, StrategyRouteType.ADDRESS);
        }
        return null;
    }

    private StrategyConditionGrayEntity getTriggeredStrategyConditionGrayEntity(Map<String, String> headerMap) {
        List strategyConditionGrayEntityList;
        StrategyCustomizationEntity strategyCustomizationEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && CollectionUtils.isNotEmpty((Collection)(strategyConditionGrayEntityList = strategyCustomizationEntity.getStrategyConditionGrayEntityList()))) {
            StrategyConditionGrayEntity globalStrategyConditionGrayEntity = this.getTriggeredGlobalStrategyConditionGrayEntity(strategyConditionGrayEntityList);
            if (globalStrategyConditionGrayEntity != null) {
                return globalStrategyConditionGrayEntity;
            }
            StrategyConditionGrayEntity expressionStrategyConditionGrayEntity = this.getTriggeredExpressionStrategyConditionGrayEntity(strategyConditionGrayEntityList, headerMap);
            if (expressionStrategyConditionGrayEntity != null) {
                return expressionStrategyConditionGrayEntity;
            }
        }
        return null;
    }

    private StrategyConditionGrayEntity getTriggeredGlobalStrategyConditionGrayEntity(List<StrategyConditionGrayEntity> strategyConditionGrayEntityList) {
        for (StrategyConditionGrayEntity strategyConditionGrayEntity : strategyConditionGrayEntityList) {
            String conditionHeader = strategyConditionGrayEntity.getConditionHeader();
            if (!StringUtils.isEmpty((CharSequence)conditionHeader)) continue;
            return strategyConditionGrayEntity;
        }
        return null;
    }

    private StrategyConditionGrayEntity getTriggeredExpressionStrategyConditionGrayEntity(List<StrategyConditionGrayEntity> strategyConditionGrayEntityList, Map<String, String> headerMap) {
        for (StrategyConditionGrayEntity strategyConditionGrayEntity : strategyConditionGrayEntityList) {
            boolean isTriggered = false;
            isTriggered = headerMap == null ? this.strategyCondition.isTriggered((StrategyConditionEntity)strategyConditionGrayEntity) : this.strategyCondition.isTriggered((StrategyConditionEntity)strategyConditionGrayEntity, headerMap);
            if (!isTriggered) continue;
            return strategyConditionGrayEntity;
        }
        return null;
    }

    private String getTriggeredStrategyGrayRoute(MapWeightEntity mapWeightEntity, StrategyRouteType strategyRouteType) {
        Map weightMap = mapWeightEntity.getWeightMap();
        if (MapUtils.isEmpty((Map)weightMap)) {
            return null;
        }
        ArrayList<ImmutablePair> weightList = new ArrayList<ImmutablePair>();
        for (Map.Entry entry : weightMap.entrySet()) {
            String id = (String)entry.getKey();
            StrategyRouteEntity strategyRouteEntity = this.getTriggeredStrategyRouteEntity(id, strategyRouteType);
            if (strategyRouteEntity == null) continue;
            String strategyRoute = strategyRouteEntity.getValue();
            Double weight = (double)((Integer)entry.getValue());
            weightList.add(new ImmutablePair((Object)strategyRoute, (Object)weight));
        }
        MapWeightRandom weightRandom = new MapWeightRandom(weightList);
        return (String)weightRandom.random();
    }

    private StrategyRouteEntity getTriggeredStrategyRouteEntity(String id, StrategyRouteType strategyRouteType) {
        List strategyRouteEntityList;
        StrategyCustomizationEntity strategyCustomizationEntity;
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && CollectionUtils.isNotEmpty((Collection)(strategyRouteEntityList = strategyCustomizationEntity.getStrategyRouteEntityList()))) {
            for (StrategyRouteEntity strategyRouteEntity : strategyRouteEntityList) {
                if (!StringUtils.equals((CharSequence)strategyRouteEntity.getId(), (CharSequence)id) || strategyRouteEntity.getType() != strategyRouteType) continue;
                return strategyRouteEntity;
            }
        }
        return null;
    }

    public Map<String, String> getHeaderMap() {
        StrategyHeaderEntity strategyHeaderEntity;
        StrategyCustomizationEntity strategyCustomizationEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && (strategyHeaderEntity = strategyCustomizationEntity.getStrategyHeaderEntity()) != null) {
            return strategyHeaderEntity.getHeaderMap();
        }
        return null;
    }

    public String getHeader(String name) {
        Map<String, String> headerMap = this.getHeaderMap();
        if (MapUtils.isNotEmpty(headerMap)) {
            return headerMap.get(name);
        }
        return null;
    }
}

