/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MissingDeprecatedCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_MISSING_DEPRECATED = "annotation.missing.deprecated";
    public static final String MSG_KEY_JAVADOC_DUPLICATE_TAG = "javadoc.duplicateTag";
    public static final String MSG_KEY_JAVADOC_MISSING = "javadoc.missing";
    private static final String DEPRECATED = "Deprecated";
    private static final String FQ_DEPRECATED = "java.lang.Deprecated";
    private static final Pattern MATCH_DEPRECATED = CommonUtils.createPattern("@(deprecated)\\s+\\S");
    private static final Pattern MATCH_DEPRECATED_MULTILINE_START = CommonUtils.createPattern("@(deprecated)\\s*$");
    private static final Pattern MATCH_DEPRECATED_MULTILINE_CONT = CommonUtils.createPattern("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private boolean skipNoJavadoc;

    public void setSkipNoJavadoc(boolean skipNoJavadoc) {
        this.skipNoJavadoc = skipNoJavadoc;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean containsJavadocTag;
        TextBlock javadoc = this.getFileContents().getJavadocBefore(ast.getLineNo());
        boolean containsAnnotation = AnnotationUtility.containsAnnotation(ast, DEPRECATED) || AnnotationUtility.containsAnnotation(ast, FQ_DEPRECATED);
        if (containsAnnotation ^ (containsJavadocTag = this.containsJavadocTag(javadoc)) && (!this.skipNoJavadoc || javadoc != null)) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_MISSING_DEPRECATED, new Object[0]);
        }
    }

    private boolean containsJavadocTag(TextBlock javadoc) {
        boolean found = false;
        if (javadoc != null) {
            String[] lines = javadoc.getText();
            int currentLine = javadoc.getStartLineNo() - 1;
            for (int i = 0; i < lines.length; ++i) {
                ++currentLine;
                String line = lines[i];
                Matcher javadocNoArgMatcher = MATCH_DEPRECATED.matcher(line);
                Matcher noArgMultilineStart = MATCH_DEPRECATED_MULTILINE_START.matcher(line);
                if (javadocNoArgMatcher.find()) {
                    if (found) {
                        this.log(currentLine, MSG_KEY_JAVADOC_DUPLICATE_TAG, JavadocTagInfo.DEPRECATED.getText());
                    }
                    found = true;
                    continue;
                }
                if (!noArgMultilineStart.find()) continue;
                found = this.checkTagAtTheRestOfComment(lines, found, currentLine, i);
            }
        }
        return found;
    }

    private boolean checkTagAtTheRestOfComment(String[] lines, boolean foundBefore, int currentLine, int index) {
        boolean found = false;
        for (int reindex = index + 1; reindex <= lines.length - 1; ++reindex) {
            Matcher multilineCont = MATCH_DEPRECATED_MULTILINE_CONT.matcher(lines[reindex]);
            if (!multilineCont.find()) continue;
            reindex = lines.length;
            String lFin = multilineCont.group(1);
            if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) {
                this.log(currentLine, MSG_KEY_JAVADOC_MISSING, new Object[0]);
                if (foundBefore) {
                    this.log(currentLine, MSG_KEY_JAVADOC_DUPLICATE_TAG, JavadocTagInfo.DEPRECATED.getText());
                }
                found = true;
                continue;
            }
            if (foundBefore) {
                this.log(currentLine, MSG_KEY_JAVADOC_DUPLICATE_TAG, JavadocTagInfo.DEPRECATED.getText());
            }
            found = true;
        }
        return found;
    }
}

