/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.common_utils;

import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.common_utils.CommonSha1Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCodecUtils.class);
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String Base64Encode(byte[] binaryData) {
        String encodedstr = new String(Base64.encodeBase64((byte[])binaryData, (boolean)false), Charsets.UTF_8);
        return encodedstr;
    }

    public static String getBufferSha1(byte[] contentBuffer) throws Exception {
        return DigestUtils.sha1Hex((byte[])contentBuffer);
    }

    public static String getEntireFileSha1(String filePath) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            String sha1Digest;
            fileInputStream = CommonFileUtils.getFileInputStream(filePath);
            String string = sha1Digest = DigestUtils.sha1Hex((InputStream)fileInputStream);
            return string;
        }
        catch (Exception e) {
            String errMsg = "getFileSha1 occur a exception, file:" + filePath + ", exception:" + e.toString();
            LOG.error(errMsg);
            throw new Exception(errMsg);
        }
        finally {
            CommonFileUtils.closeFileStream(fileInputStream, filePath);
        }
    }

    public static String getSlicePartSha1(String localPath, int sliceSize, StringBuilder entireSha1Builder) throws Exception {
        if (sliceSize > 0x100000) {
            sliceSize = 0x100000;
        }
        JSONArray jsonArray = new JSONArray();
        FileInputStream fileInput = null;
        try {
            int totalCount;
            int maxRead;
            CommonSha1Utils sha1Utils = new CommonSha1Utils();
            sha1Utils.init();
            fileInput = CommonFileUtils.getFileInputStream(localPath);
            long fileLength = CommonFileUtils.getFileLength(localPath);
            int sliceCount = new Long((fileLength + (long)(sliceSize - 1)) / (long)sliceSize).intValue();
            int BUFFER_LEN = 1024;
            byte[] contentBuf = null;
            for (int sliceIndex = 0; sliceIndex < sliceCount - 1; ++sliceIndex) {
                int totalCount2;
                int maxRead2;
                long sliceOffset = sliceIndex;
                sliceOffset *= (long)sliceSize;
                for (totalCount2 = 0; totalCount2 < sliceSize; totalCount2 += maxRead2) {
                    maxRead2 = sliceSize - totalCount2;
                    if (maxRead2 > 1024) {
                        maxRead2 = 1024;
                    }
                    contentBuf = new byte[maxRead2];
                    ((InputStream)fileInput).read(contentBuf, 0, maxRead2);
                    sha1Utils.update(contentBuf);
                }
                JSONObject sliceJson = new JSONObject();
                sliceJson.put("offset", sliceOffset);
                sliceJson.put("datalen", totalCount2);
                sliceJson.put("datasha", (Object)sha1Utils.dumpTempState());
                jsonArray.put(sliceIndex, (Object)sliceJson);
            }
            long sliceOffset = (long)(sliceCount - 1) * (long)sliceSize;
            int leftSlice = new Long(fileLength - sliceOffset).intValue();
            for (totalCount = 0; totalCount < leftSlice; totalCount += maxRead) {
                maxRead = leftSlice - totalCount;
                if (maxRead > 1024) {
                    maxRead = 1024;
                }
                contentBuf = new byte[maxRead];
                ((InputStream)fileInput).read(contentBuf, 0, maxRead);
                sha1Utils.update(contentBuf);
            }
            sha1Utils.finish();
            entireSha1Builder.append(sha1Utils.digout());
            JSONObject sliceJson = new JSONObject();
            sliceJson.put("offset", sliceOffset);
            sliceJson.put("datalen", totalCount);
            sliceJson.put("datasha", (Object)sha1Utils.digout());
            jsonArray.put(sliceCount - 1, (Object)sliceJson);
        }
        catch (Exception e) {
            try {
                LOG.error("getSlicePartSha1 occur a error, filePath:{}, sliceSize:{}, exception:{}", new Object[]{localPath, sliceSize, e.toString()});
                throw e;
            }
            catch (Throwable throwable) {
                CommonFileUtils.closeFileStream(fileInput, localPath);
                throw throwable;
            }
        }
        CommonFileUtils.closeFileStream(fileInput, localPath);
        return jsonArray.toString();
    }

    public static String getSlicePartSha1(byte[] contentBuffer, int sliceSize, StringBuilder entireSha1Builder) throws Exception {
        if (sliceSize > 0x100000) {
            sliceSize = 0x100000;
        }
        JSONArray jsonArray = new JSONArray();
        InputStream fileInput = null;
        try {
            int totalCount;
            int maxRead;
            CommonSha1Utils sha1Utils = new CommonSha1Utils();
            sha1Utils.init();
            fileInput = new ByteArrayInputStream(contentBuffer);
            long fileLength = contentBuffer.length;
            int sliceCount = new Long((fileLength + (long)(sliceSize - 1)) / (long)sliceSize).intValue();
            int BUFFER_LEN = 1024;
            byte[] contentBuf = null;
            for (int sliceIndex = 0; sliceIndex < sliceCount - 1; ++sliceIndex) {
                int totalCount2;
                int maxRead2;
                long sliceOffset = (long)sliceIndex * (long)sliceSize;
                for (totalCount2 = 0; totalCount2 < sliceSize; totalCount2 += maxRead2) {
                    maxRead2 = sliceSize - totalCount2;
                    if (maxRead2 > 1024) {
                        maxRead2 = 1024;
                    }
                    contentBuf = new byte[maxRead2];
                    fileInput.read(contentBuf, 0, maxRead2);
                    sha1Utils.update(contentBuf);
                }
                JSONObject sliceJson = new JSONObject();
                sliceJson.put("offset", sliceOffset);
                sliceJson.put("datalen", totalCount2);
                sliceJson.put("datasha", (Object)sha1Utils.dumpTempState());
                jsonArray.put(sliceIndex, (Object)sliceJson);
            }
            long sliceOffset = (long)(sliceCount - 1) * (long)sliceSize;
            int leftSlice = new Long(fileLength - sliceOffset).intValue();
            for (totalCount = 0; totalCount < leftSlice; totalCount += maxRead) {
                maxRead = leftSlice - totalCount;
                if (maxRead > 1024) {
                    maxRead = 1024;
                }
                contentBuf = new byte[maxRead];
                fileInput.read(contentBuf, 0, maxRead);
                sha1Utils.update(contentBuf);
            }
            sha1Utils.finish();
            entireSha1Builder.append(sha1Utils.digout());
            JSONObject sliceJson = new JSONObject();
            sliceJson.put("offset", sliceOffset);
            sliceJson.put("datalen", totalCount);
            sliceJson.put("datasha", (Object)sha1Utils.digout());
            jsonArray.put(sliceCount - 1, (Object)sliceJson);
        }
        catch (Exception e) {
            LOG.error("getSlicePartSha1 from buffer occur a error, sliceSize:{}, exception:{}", (Object)sliceSize, (Object)e.toString());
            throw e;
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {}
            }
        }
        return jsonArray.toString();
    }

    public static byte[] HmacSha1(byte[] binaryData, String key) throws Exception {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1);
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1);
            mac.init(secretKey);
            byte[] HmacSha1Digest = mac.doFinal(binaryData);
            return HmacSha1Digest;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("mac not find algorithm {}", (Object)HMAC_SHA1);
            throw e;
        }
        catch (InvalidKeyException e) {
            LOG.error("mac init key {} occur a error {}", (Object)key, (Object)e.toString());
            throw e;
        }
        catch (IllegalStateException e) {
            LOG.error("mac.doFinal occur a error {}", (Object)e.toString());
            throw e;
        }
    }

    public static byte[] HmacSha1(String plainText, String key) throws Exception {
        return CommonCodecUtils.HmacSha1(plainText.getBytes(), key);
    }
}

