/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.op;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.op.BaseOp;
import com.qcloud.cos.request.CreateFolderRequest;
import com.qcloud.cos.request.DelFolderRequest;
import com.qcloud.cos.request.ListFolderRequest;
import com.qcloud.cos.request.StatFolderRequest;
import com.qcloud.cos.request.UpdateFolderRequest;
import com.qcloud.cos.sign.Credentials;
import com.qcloud.cos.sign.Sign;

public class FolderOp
extends BaseOp {
    public FolderOp(ClientConfig config, Credentials cred, AbstractCosHttpClient client) {
        super(config, cred, client);
    }

    public String updateFolder(UpdateFolderRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        String sign = Sign.getOneEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "update");
        httpRequest.addParam("biz_attr", request.getBizAttr());
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String delFolder(DelFolderRequest request) throws AbstractCosException {
        return super.delBase(request);
    }

    public String statFolder(StatFolderRequest request) throws AbstractCosException {
        return super.statBase(request);
    }

    public String createFolder(CreateFolderRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "create");
        httpRequest.addParam("biz_attr", request.getBizAttr());
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String listFolder(ListFolderRequest request) throws AbstractCosException {
        request.check_param();
        request.setCosPath(request.getCosPath() + request.getPrefix());
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "list");
        httpRequest.addParam("num", String.valueOf(request.getNum()));
        httpRequest.addParam("list_flag", String.valueOf(request.getListFlag()));
        httpRequest.addParam("context", request.getContext());
        httpRequest.addParam("delimiter", request.getDelimiter());
        httpRequest.setMethod(HttpMethod.GET);
        return this.httpClient.sendHttpRequest(httpRequest);
    }
}

