/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.formatting;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.internal.StreamUtils;
import com.samczsun.skype4j.internal.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;

public class Generator {
    private static final String LANG = "en";
    private static final String VERSION = "908_1.20.0.98";

    public static void main(String[] args) throws Exception {
        URL url = new URL("https://a.config.skype.com/config/v1/Skype/908_1.20.0.98/SkypePersonalization?apikey=skype.com&id=self&callback=Skype4J");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "Skype4J");
        String str = StreamUtils.readFully(connection.getInputStream());
        JsonObject object = JsonObject.readFrom(str.substring(12, str.length() - 1));
        String configloc = object.get("pes_config").asString();
        configloc = configloc.substring(0, configloc.lastIndexOf(47) + 1);
        URL config = new URL(configloc + LANG);
        connection = (HttpURLConnection)config.openConnection();
        connection.setRequestProperty("User-Agent", "Skype4J");
        JsonObject root = Utils.parseJsonObject(connection.getInputStream());
        JsonArray items = root.get("items").asArray();
        Scanner in = new Scanner(new File("src/main/java/com/samczsun/skype4j/formatting/lang/DefaultEmoticon.java"), "UTF-8");
        File f = new File("src/main/java/com/samczsun/skype4j/formatting/lang/en/Emoticon.java");
        if (!f.exists()) {
            if (!f.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("Could not create folder");
            }
            if (!f.createNewFile()) {
                throw new IllegalArgumentException("Could not create file");
            }
        }
        PrintWriter pr = new PrintWriter(f, "UTF-8");
        while (in.hasNextLine()) {
            String next = in.nextLine();
            if (next.startsWith("package")) {
                pr.println("package com.samczsun.skype4j.formatting.lang.en;");
                continue;
            }
            if (next.contains("DefaultEmoticon")) {
                pr.println(next.replace("DefaultEmoticon", "Emoticon"));
                continue;
            }
            if (next.trim().equals(";")) {
                ArrayList<JsonObject> emoticons = new ArrayList<JsonObject>();
                for (JsonValue val : items) {
                    if (!val.asObject().get("type").asString().equals("emoticon")) continue;
                    emoticons.add(val.asObject());
                }
                for (int i = 0; i < emoticons.size(); ++i) {
                    JsonObject obj = (JsonObject)emoticons.get(i);
                    String enumname = obj.get("id").asString().toUpperCase().replace(' ', '_');
                    String id = obj.get("id").asString();
                    String etag = obj.get("etag").asString();
                    String desc = obj.get("description").asString();
                    String shortcuts = obj.get("shortcuts").toString();
                    shortcuts = shortcuts.substring(1, shortcuts.length() - 1);
                    pr.println(String.format("    %s(\"%s\",\"%s\",\"%s\",%s)" + (i == emoticons.size() - 1 ? ";" : ","), enumname, id, etag, desc, shortcuts));
                }
                continue;
            }
            pr.println(next);
        }
        pr.close();
        in = new Scanner(new File("src/main/java/com/samczsun/skype4j/formatting/lang/DefaultFlik.java"));
        f = new File("src/main/java/com/samczsun/skype4j/formatting/lang/en/Moji.java");
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(f);
        PrintWriter pr2 = new PrintWriter(out);
        while (in.hasNextLine()) {
            String next = in.nextLine();
            if (next.startsWith("package")) {
                pr2.println("package com.samczsun.skype4j.formatting.lang.en;");
                continue;
            }
            if (next.contains("DefaultFlik")) {
                pr2.println(next.replace("DefaultFlik", "Flik"));
                continue;
            }
            if (next.trim().equals(";")) {
                ArrayList<JsonObject> emoticons = new ArrayList<JsonObject>();
                for (JsonValue val : items) {
                    if (!val.asObject().get("type").asString().equals("flik")) continue;
                    emoticons.add(val.asObject());
                }
                HashSet<String> enumnames = new HashSet<String>();
                for (int i = 0; i < emoticons.size(); ++i) {
                    String enumname;
                    JsonObject obj = (JsonObject)emoticons.get(i);
                    int x = 0;
                    String orig = enumname = obj.get("description").asString().toUpperCase().replace(' ', '_').replaceAll("[^a-zA-Z]", "");
                    String id = obj.get("id").asString();
                    String etag = obj.get("etag").asString();
                    String desc = obj.get("description").asString();
                    while (!enumnames.add(enumname)) {
                        enumname = orig + "_" + ++x;
                    }
                    pr2.println(String.format("    %s(\"%s\", \"%s\", \"%s\")" + (i == emoticons.size() - 1 ? ";" : ","), enumname, id, etag, desc));
                }
                continue;
            }
            pr2.println(next);
        }
        pr2.close();
    }
}

