/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.client.FullClient;
import com.samczsun.skype4j.user.Contact;
import com.samczsun.skype4j.user.ContactRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContactRequestImpl
implements ContactRequest {
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private Date time;
    private String sender;
    private String message;
    private FullClient skype;

    public ContactRequestImpl(String time, String sender, String message, FullClient skype) throws ParseException {
        this.time = this.FORMAT.parse(time);
        this.sender = sender;
        this.message = message;
        this.skype = skype;
    }

    @Override
    public Date getTime() {
        return new Date(this.time.getTime());
    }

    @Override
    public Contact getSender() throws ConnectionException {
        return this.skype.getOrLoadContact(this.sender);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void accept() throws ConnectionException {
        Endpoints.ACCEPT_CONTACT_REQUEST.open(this.skype, this.sender).expect(201, "While accepting contact request").put();
    }

    @Override
    public void decline() throws ConnectionException {
        Endpoints.DECLINE_CONTACT_REQUEST.open(this.skype, this.sender).expect(201, "While declining contact request").put();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactRequestImpl that = (ContactRequestImpl)o;
        if (this.time != null ? !this.time.equals(that.time) : that.time != null) {
            return false;
        }
        if (this.sender != null ? !this.sender.equals(that.sender) : that.sender != null) {
            return false;
        }
        return !(this.message == null ? that.message != null : !this.message.equals(that.message));
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 31 * result + (this.sender != null ? this.sender.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

