/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.chat;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.chat.GroupChat;
import com.samczsun.skype4j.chat.messages.ChatMessage;
import com.samczsun.skype4j.events.chat.user.action.OptionUpdateEvent;
import com.samczsun.skype4j.exceptions.ChatNotFoundException;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.formatting.Message;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.MessageType;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.UserImpl;
import com.samczsun.skype4j.internal.Utils;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import com.samczsun.skype4j.internal.chat.messages.ChatMessageImpl;
import com.samczsun.skype4j.user.Contact;
import com.samczsun.skype4j.user.User;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;

public class ChatGroup
extends ChatImpl
implements GroupChat {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private String topic;
    private String pictureUrl;
    private boolean pictureUpdated;
    private BufferedImage picture;
    private String backwardLink;
    private String syncState;
    private Set<OptionUpdateEvent.Option> enabledOptions;

    protected ChatGroup(SkypeImpl skype, String identity) throws ConnectionException, ChatNotFoundException {
        super(skype, identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() throws ConnectionException, ChatNotFoundException {
        if (this.isLoaded()) {
            return;
        }
        this.enabledOptions = new HashSet<OptionUpdateEvent.Option>();
        try {
            this.isLoading.set(true);
            HashMap<String, UserImpl> newUsers = new HashMap<String, UserImpl>();
            JsonObject object = Endpoints.CHAT_INFO_URL.open(this.getClient(), this.getIdentity()).as(JsonObject.class).on(404, connection -> {
                throw new ChatNotFoundException();
            }).expect(200, "While loading users").get();
            JsonObject props = object.get("properties").asObject();
            for (OptionUpdateEvent.Option option : OptionUpdateEvent.Option.values()) {
                if (props.get(option.getId()) == null || !props.get(option.getId()).asString().equals("true")) continue;
                this.enabledOptions.add(option);
            }
            this.topic = props.get("topic") != null ? props.get("topic").asString() : "";
            if (props.get("picture") != null) {
                this.pictureUrl = props.get("picture").asString().substring(4);
            }
            JsonArray members = object.get("members").asArray();
            for (JsonValue element : members) {
                String username = element.asObject().get("id").asString().substring(2);
                String role = element.asObject().get("role").asString();
                UserImpl user = (UserImpl)this.users.get(username.toLowerCase());
                if (user == null) {
                    user = new UserImpl(username, this, this.getClient());
                }
                newUsers.put(username.toLowerCase(), user);
                if (role.equalsIgnoreCase("admin")) {
                    user.updateRole(User.Role.ADMIN);
                    continue;
                }
                user.updateRole(User.Role.USER);
            }
            this.users.clear();
            this.users.putAll(newUsers);
            this.hasLoaded.set(true);
        }
        finally {
            this.isLoading.set(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ChatMessage> loadMoreMessages(int amount) throws ConnectionException {
        this.checkLoaded();
        JsonObject data = null;
        if (this.backwardLink == null) {
            if (this.syncState != null) return Collections.emptyList();
            data = Endpoints.LOAD_MESSAGES.open(this.getClient(), this.getIdentity(), amount).as(JsonObject.class).expect(200, "While loading messages").get();
        } else {
            Matcher matcher = SkypeImpl.PAGE_SIZE_PATTERN.matcher(this.backwardLink);
            matcher.find();
            String url = matcher.replaceAll("pageSize=" + amount);
            data = Endpoints.custom(url, this.getClient(), new String[0]).header("RegistrationToken", this.getClient().getRegistrationToken()).as(JsonObject.class).expect(200, "While loading messages").get();
        }
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        for (JsonValue value : data.get("messages").asArray()) {
            try {
                JsonObject msg = value.asObject();
                if (!msg.get("messagetype").asString().equals("RichText")) continue;
                UserImpl u = (UserImpl)MessageType.getUser(msg.get("from").asString(), this);
                ChatMessage m = ChatMessageImpl.createMessage(this, u, msg.get("id").asString(), msg.get("id").asString(), this.formatter.parse(msg.get("originalarrivaltime").asString()).getTime(), Message.fromHtml(MessageType.stripMetadata(msg.get("content").asString())), this.getClient());
                this.messages.add(0, m);
                u.insertMessage(m, 0);
                messages.add(m);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        JsonObject metadata = data.get("_metadata").asObject();
        this.backwardLink = metadata.get("backwardLink") != null ? metadata.get("backwardLink").asString() : null;
        this.syncState = metadata.get("syncState").asString();
        return messages;
    }

    @Override
    public void addUser(String username) throws ConnectionException {
        if (!this.users.containsKey(username.toLowerCase())) {
            UserImpl user = new UserImpl(username, this, this.getClient());
            this.users.put(username.toLowerCase(), user);
        } else if (!username.equalsIgnoreCase(this.getClient().getUsername())) {
            throw new IllegalArgumentException(username + " joined the chat even though he was already in it?");
        }
    }

    @Override
    public void removeUser(String username) {
        this.users.remove(username.toLowerCase());
    }

    @Override
    public void kick(String username) throws ConnectionException {
        this.checkLoaded();
        Endpoints.MODIFY_MEMBER_URL.open(this.getClient(), this.getIdentity(), username).expect(200, "While kicking user").delete();
    }

    @Override
    public void leave() throws ConnectionException {
        this.kick(this.getClient().getUsername());
    }

    @Override
    public String getJoinUrl() throws ConnectionException {
        this.checkLoaded();
        if (this.isOptionEnabled(OptionUpdateEvent.Option.JOINING_ENABLED)) {
            JsonObject data = new JsonObject();
            data.add("baseDomain", "https://join.skype.com/launch/");
            data.add("threadId", this.getIdentity());
            JsonObject object = Endpoints.GET_JOIN_URL.open(this.getClient(), new Object[0]).as(JsonObject.class).expect(200, "While getting join URL").post(data);
            return object.get("JoinUrl").asString();
        }
        throw new IllegalStateException("Joining is not enabled");
    }

    @Override
    public String getTopic() {
        this.checkLoaded();
        return this.topic;
    }

    @Override
    public void setTopic(String topic) throws ConnectionException {
        this.checkLoaded();
        this.putOption("topic", JsonValue.valueOf(topic), true);
    }

    @Override
    public BufferedImage getPicture() throws ConnectionException {
        this.checkLoaded();
        if (this.pictureUrl != null) {
            if (this.pictureUpdated) {
                this.picture = null;
                this.pictureUpdated = false;
            }
            if (this.picture == null) {
                this.picture = Endpoints.custom(this.pictureUrl, this.getClient(), new String[0]).as(BufferedImage.class).expect(200, "While fetching image").header("Authorization", Endpoints.AUTHORIZATION.provide(this.getClient())).get();
            }
            BufferedImage clone = new BufferedImage(this.picture.getWidth(), this.picture.getHeight(), this.picture.getType());
            Graphics2D g2d = clone.createGraphics();
            g2d.drawImage((Image)this.picture, 0, 0, null);
            g2d.dispose();
            return clone;
        }
        return null;
    }

    @Override
    public void setImage(BufferedImage image, String imageType) throws ConnectionException, IOException {
        this.checkLoaded();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, imageType, baos);
        String id = Utils.uploadImage(baos.toByteArray(), Utils.ImageType.AVATAR, this);
        this.putOption("picture", JsonValue.valueOf(String.format("URL@https://api.asm.skype.com/v1/objects/%s/views/avatar_fullsize", id)), true);
    }

    @Override
    public void setImage(File image) throws ConnectionException, IOException {
        this.checkLoaded();
        byte[] data = Files.readAllBytes(image.toPath());
        String id = Utils.uploadImage(data, Utils.ImageType.AVATAR, this);
        this.putOption("picture", JsonValue.valueOf(String.format("URL@https://api.asm.skype.com/v1/objects/%s/views/avatar_fullsize", id)), true);
    }

    @Override
    public boolean isOptionEnabled(OptionUpdateEvent.Option option) {
        this.checkLoaded();
        return this.enabledOptions.contains((Object)option);
    }

    @Override
    public void setOptionEnabled(OptionUpdateEvent.Option option, boolean enabled) throws ConnectionException {
        this.checkLoaded();
        this.putOption(option.getId(), JsonValue.valueOf(enabled), true);
        this.updateOption(option, enabled);
    }

    @Override
    public void add(Contact contact) throws ConnectionException {
        this.checkLoaded();
        Endpoints.ADD_MEMBER_URL.open(this.getClient(), this.getIdentity(), contact.getUsername()).expect(200, "While adding user to group").put(new JsonObject().add("role", "User"));
    }

    public void updateTopic(String topic) {
        this.topic = topic;
    }

    public void updatePicture(String picture) {
        this.pictureUrl = picture;
        this.pictureUpdated = true;
    }

    public void updateOption(OptionUpdateEvent.Option option, boolean enabled) {
        if (enabled) {
            this.enabledOptions.add(option);
        } else {
            this.enabledOptions.remove((Object)option);
        }
    }
}

