/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.chat;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.chat.Chat;
import com.samczsun.skype4j.chat.messages.ChatMessage;
import com.samczsun.skype4j.exceptions.ChatNotFoundException;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.NotLoadedException;
import com.samczsun.skype4j.formatting.IMoji;
import com.samczsun.skype4j.formatting.Message;
import com.samczsun.skype4j.formatting.Text;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.ExceptionHandler;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.StreamUtils;
import com.samczsun.skype4j.internal.UserImpl;
import com.samczsun.skype4j.internal.Utils;
import com.samczsun.skype4j.internal.chat.ChatGroup;
import com.samczsun.skype4j.internal.chat.ChatIndividual;
import com.samczsun.skype4j.internal.chat.messages.ChatMessageImpl;
import com.samczsun.skype4j.user.Contact;
import com.samczsun.skype4j.user.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.jsoup.helper.Validate;

public abstract class ChatImpl
implements Chat {
    protected final AtomicBoolean isLoading = new AtomicBoolean(false);
    protected final AtomicBoolean hasLoaded = new AtomicBoolean(false);
    protected final Map<String, UserImpl> users = new ConcurrentHashMap<String, UserImpl>();
    protected final List<ChatMessage> messages = new CopyOnWriteArrayList<ChatMessage>();
    private final SkypeImpl client;
    private final String identity;

    ChatImpl(SkypeImpl client, String identity) throws ConnectionException, ChatNotFoundException {
        this.client = client;
        this.identity = identity;
        this.load();
    }

    @Override
    public ChatMessage sendMessage(Message message) throws ConnectionException {
        this.checkLoaded();
        long ms = System.currentTimeMillis();
        JsonObject obj = new JsonObject();
        obj.add("content", message.write());
        obj.add("messagetype", "RichText");
        obj.add("contenttype", "text");
        obj.add("clientmessageid", String.valueOf(ms));
        Endpoints.SEND_MESSAGE_URL.open(this.getClient(), this.getIdentity()).expect(201, "While sending message").post(obj);
        return ChatMessageImpl.createMessage(this, this.getUser(this.client.getUsername()), null, String.valueOf(ms), ms, message, this.getClient());
    }

    @Override
    public ChatMessage sendMessage(String plainMessage) throws ConnectionException {
        return this.sendMessage(Message.create().with(Text.plain(plainMessage)));
    }

    @Override
    public void sendContact(Contact contact) throws ConnectionException {
        this.checkLoaded();
        long ms = System.currentTimeMillis();
        JsonObject obj = new JsonObject();
        obj.add("content", String.format("<contacts><c t=\"s\" s=\"%s\" f=\"%s\"/></contacts>", contact.getUsername(), contact.getDisplayName()));
        obj.add("messagetype", "RichText/Contacts");
        obj.add("contenttype", "text");
        obj.add("clientmessageid", String.valueOf(ms));
        Endpoints.SEND_MESSAGE_URL.open(this.getClient(), this.getIdentity()).expect(201, "While sending message").post(obj);
    }

    @Override
    public void sendImage(BufferedImage image, String imageType, String imageName) throws ConnectionException, IOException {
        this.checkLoaded();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, imageType, baos);
        this.sendImage(baos.toByteArray(), imageName);
    }

    @Override
    public void sendImage(File image) throws ConnectionException, IOException {
        this.checkLoaded();
        byte[] data = Files.readAllBytes(image.toPath());
        String name = image.getName().substring(0, image.getName().lastIndexOf(46));
        this.sendImage(data, name);
    }

    private void sendImage(byte[] data, String imageName) throws ConnectionException, IOException {
        String id = Utils.uploadImage(data, Utils.ImageType.IMGT1, this);
        long ms = System.currentTimeMillis();
        String content = "<URIObject type=\"Picture.1\" uri=\"https://api.asm.skype.com/v1/objects/%s\" url_thumbnail=\"https://api.asm.skype.com/v1/objects/%s/views/imgt1\">MyLegacy pish <a href=\"https://api.asm.skype.com/s/i?%s\">https://api.asm.skype.com/s/i?%s</a><Title/><Description/><OriginalName v=\"%s\"/><meta type=\"photo\" originalName=\"%s\"/></URIObject>";
        content = String.format(content, id, id, id, id, imageName, imageName);
        JsonObject obj = new JsonObject();
        obj.add("content", content);
        obj.add("messagetype", "RichText/UriObject");
        obj.add("contenttype", "text");
        obj.add("clientmessageid", String.valueOf(ms));
        Endpoints.SEND_MESSAGE_URL.open(this.getClient(), this.getIdentity()).expect(201, "While sending message").post(obj);
    }

    @Override
    public void sendFile(File file) throws ConnectionException {
        this.checkLoaded();
        try {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamUtils.copy(in, out);
            String id = Utils.upload(out.toByteArray(), Utils.ImageType.FILE, new JsonObject().add("filename", file.getName()), this);
            long ms = System.currentTimeMillis();
            String content = "<URIObject type=\"File.1\" uri=\"https://api.asm.skype.com/v1/objects/%s\" url_thumbnail=\"https://api.asm.skype.com/v1/objects/%s/views/thumbnail\"><Title>Title: %s</Title><Description> Description: %s</Description><a href=\"https://login.skype.com/login/sso?go=webclient.xmm&amp;docid=%s\"> https://login.skype.com/login/sso?go=webclient.xmm&amp;docid=%s</a><OriginalName v=\"%s\"/><FileSize v=\"%s\"/></URIObject>";
            content = String.format(content, id, id, file.getName(), file.getName(), id, id, file.getName(), out.size());
            JsonObject obj = new JsonObject();
            obj.add("content", content);
            obj.add("messagetype", "RichText/Media_GenericFile");
            obj.add("contenttype", "text");
            obj.add("clientmessageid", String.valueOf(ms));
            Endpoints.SEND_MESSAGE_URL.open(this.getClient(), this.getIdentity()).expect(201, "While sending message").post(obj);
        }
        catch (IOException e) {
            throw ExceptionHandler.generateException("While sending message", e);
        }
    }

    @Override
    public void sendMoji(IMoji flik) throws ConnectionException {
        this.checkLoaded();
        long ms = System.currentTimeMillis();
        String content = "<URIObject type=\"Video.1/Flik.1\" uri=\"https://static.asm.skype.com/pes/v1/items/%s\" url_thumbnail=\"https://static.asm.skype.com/pes/v1/items/%s/views/thumbnail\"><a href=\"https://static.asm.skype.com/pes/v1/items/%s/views/default\">https://static.asm.skype.com/pes/v1/items/%s/views/default</a><OriginalName v=\"\"/></URIObject>";
        content = String.format(content, flik.getId(), flik.getId(), flik.getId(), flik.getId());
        JsonObject obj = new JsonObject();
        obj.add("content", content);
        obj.add("messagetype", "RichText/Media_FlikMsg");
        obj.add("contenttype", "text");
        obj.add("clientmessageid", String.valueOf(ms));
        Endpoints.SEND_MESSAGE_URL.open(this.getClient(), this.getIdentity()).expect(201, "While sending message").post(obj);
    }

    @Override
    public Collection<User> getAllUsers() {
        this.checkLoaded();
        return Collections.unmodifiableCollection(this.users.values());
    }

    @Override
    public UserImpl getUser(String username) {
        this.checkLoaded();
        return this.users.get(username.toLowerCase());
    }

    @Override
    public User getSelf() {
        return this.getUser(this.getClient().getUsername());
    }

    @Override
    public List<ChatMessage> getAllMessages() {
        this.checkLoaded();
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public SkypeImpl getClient() {
        return this.client;
    }

    public static ChatImpl createChat(SkypeImpl client, String identity) throws ConnectionException, ChatNotFoundException {
        Validate.notNull(client, "Client must not be null");
        Validate.notEmpty(identity, "Identity must not be null/empty");
        if (identity.startsWith("19:")) {
            if (identity.endsWith("@thread.skype")) {
                return new ChatGroup(client, identity);
            }
            throw new IllegalArgumentException(String.format("Cannot load P2P chat with identity %s", identity));
        }
        if (identity.startsWith("8:")) {
            return new ChatIndividual(client, identity);
        }
        throw new IllegalArgumentException(String.format("Unknown chat type with identity %s", identity));
    }

    public void onMessage(ChatMessage message) {
        this.messages.add(message);
        ((UserImpl)message.getSender()).onMessage(message);
    }

    @Override
    public void alertsOff() throws ConnectionException {
        this.putOption("alerts", JsonValue.valueOf(false), false);
    }

    @Override
    public void alertsOn() throws ConnectionException {
        this.alertsOn(null);
    }

    @Override
    public void alertsOn(String keyword) throws ConnectionException {
        this.putOption("alerts", JsonValue.valueOf(true), false);
        this.putOption("alertmatches", JsonValue.valueOf(keyword), false);
    }

    @Override
    public boolean isLoaded() {
        return !this.isLoading.get() && this.hasLoaded.get();
    }

    public abstract void addUser(String var1) throws ConnectionException;

    public abstract void removeUser(String var1);

    protected abstract void load() throws ConnectionException, ChatNotFoundException;

    protected void checkLoaded() {
        if (!this.isLoaded()) {
            throw new NotLoadedException();
        }
    }

    protected void putOption(String option, JsonValue value, boolean global) throws ConnectionException {
        JsonObject obj = new JsonObject();
        obj.add(option, value);
        (global ? Endpoints.CONVERSATION_PROPERTY_GLOBAL : Endpoints.CONVERSATION_PROPERTY_SELF).open(this.getClient(), this.getIdentity(), option).expect(200, "While updating option").put(obj);
    }
}

