/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.chat.messages;

import com.samczsun.skype4j.chat.Chat;
import com.samczsun.skype4j.chat.messages.ChatMessage;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.formatting.Message;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.UserImpl;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import com.samczsun.skype4j.internal.chat.messages.ReceivedMessageImpl;
import com.samczsun.skype4j.internal.chat.messages.SentMessageImpl;
import com.samczsun.skype4j.user.User;
import org.jsoup.helper.Validate;

public abstract class ChatMessageImpl
implements ChatMessage {
    private Chat chat;
    private User sender;
    private String clientId;
    private String id;
    private Message message;
    private long time;
    private SkypeImpl skype;

    public ChatMessageImpl(Chat chat, User sender, String id, String clientId, long time, Message message, SkypeImpl skype) {
        this.chat = chat;
        this.sender = sender;
        this.id = id;
        this.clientId = clientId;
        this.time = time;
        this.message = message;
        this.skype = skype;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public User getSender() {
        return this.sender;
    }

    @Override
    public Message getContent() {
        return this.message;
    }

    @Override
    public long getSentTime() {
        return this.time;
    }

    @Override
    public Chat getChat() {
        return this.chat;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SkypeImpl getClient() {
        return this.skype;
    }

    public static ChatMessage createMessage(Chat chat, User user, String id, String clientId, long time, Message message, SkypeImpl skype) throws ConnectionException {
        Validate.notNull(chat, "Chat must not be null");
        Validate.isTrue(chat instanceof ChatImpl, "Chat must be instanceof ChatImpl");
        Validate.notNull(user, "User must not be null");
        Validate.isTrue(user instanceof UserImpl, "User must be instanceof UserImpl");
        if (((ChatImpl)chat).getClient().getUsername().equals(user.getUsername())) {
            return new SentMessageImpl(chat, user, id, clientId, time, message, skype);
        }
        return new ReceivedMessageImpl(chat, user, id, clientId, time, message, skype);
    }

    public void edit0(Message newMessage) {
        this.message = newMessage;
    }
}

