/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler;

import com.sun.org.apache.commons.modeler.FeatureInfo;
import com.sun.org.apache.commons.modeler.ParameterInfo;
import java.io.Serializable;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class OperationInfo
extends FeatureInfo
implements Serializable {
    static final long serialVersionUID = 4418342922072614875L;
    transient ModelMBeanOperationInfo info = null;
    protected String impact = "UNKNOWN";
    protected String role = "operation";
    protected String returnType = "void";
    protected ParameterInfo[] parameters = new ParameterInfo[0];

    public OperationInfo() {
    }

    public OperationInfo(String name, boolean getter, String type) {
        this.setName(name);
        if (getter) {
            this.setDescription("Attribute getter method");
            this.setImpact("INFO");
            this.setReturnType(type);
            this.setRole("getter");
        } else {
            this.setDescription("Attribute setter method");
            this.setImpact("ACTION");
            this.setReturnType("void");
            this.setRole("setter");
            this.addParameter(new ParameterInfo("value", type, "New attribute value"));
        }
    }

    public void setDescription(String description) {
        super.setDescription(description);
        this.info = null;
    }

    public void setName(String name) {
        super.setName(name);
        this.info = null;
    }

    public String getImpact() {
        return this.impact;
    }

    public void setImpact(String impact) {
        this.impact = impact == null ? null : impact.toUpperCase();
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public ParameterInfo[] getSignature() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(ParameterInfo parameter) {
        ParameterInfo[] parameterInfoArray = this.parameters;
        synchronized (this.parameters) {
            ParameterInfo[] results = new ParameterInfo[this.parameters.length + 1];
            System.arraycopy(this.parameters, 0, results, 0, this.parameters.length);
            results[this.parameters.length] = parameter;
            this.parameters = results;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ModelMBeanOperationInfo createOperationInfo() {
        if (this.info != null) {
            return this.info;
        }
        ParameterInfo[] params = this.getSignature();
        MBeanParameterInfo[] parameters = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameters[i] = params[i].createParameterInfo();
        }
        int impact = 3;
        if ("ACTION".equals(this.getImpact())) {
            impact = 1;
        } else if ("ACTION_INFO".equals(this.getImpact())) {
            impact = 2;
        } else if ("INFO".equals(this.getImpact())) {
            impact = 0;
        }
        this.info = new ModelMBeanOperationInfo(this.getName(), this.getDescription(), parameters, this.getReturnType(), impact);
        Descriptor descriptor = this.info.getDescriptor();
        descriptor.removeField("class");
        descriptor.setField("role", this.getRole());
        this.addFields(descriptor);
        this.info.setDescriptor(descriptor);
        return this.info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OperationInfo[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", returnType=");
        sb.append(this.returnType);
        sb.append(", parameters=");
        sb.append(this.parameters.length);
        sb.append("]");
        return sb.toString();
    }
}

