/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler.mbeans;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.BaseModelMBean;
import com.sun.org.apache.commons.modeler.mbeans.SimpleRemoteConnector;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

class MBeanProxy
extends BaseModelMBean {
    private static Log log = LogFactory.getLog(MBeanProxy.class);
    HashMap atts = new HashMap();
    SimpleRemoteConnector jkmx;

    public MBeanProxy(SimpleRemoteConnector jkmx, String code) throws Exception {
        this.jkmx = jkmx;
        this.initModelInfo(code);
    }

    protected void update(String name, String val) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating " + this.oname + " " + name + " " + val));
        }
        this.atts.put(name, val);
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.jkmx.refresh();
        return this.atts.get(name);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            this.jkmx.setAttribute(this.oname, attribute);
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            this.jkmx.invoke(this.oname, name, params, signature);
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
        return null;
    }
}

