/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.orderby;

import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.common.StreamMergedResult;
import io.shardingsphere.core.merger.dql.orderby.OrderByValue;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import java.sql.SQLException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class OrderByStreamMergedResult
extends StreamMergedResult {
    private final List<OrderItem> orderByItems;
    private final Queue<OrderByValue> orderByValuesQueue;
    private boolean isFirstNext;

    public OrderByStreamMergedResult(List<QueryResult> queryResults, List<OrderItem> orderByItems) throws SQLException {
        this.orderByItems = orderByItems;
        this.orderByValuesQueue = new PriorityQueue<OrderByValue>(queryResults.size());
        this.orderResultSetsToQueue(queryResults);
        this.isFirstNext = true;
    }

    private void orderResultSetsToQueue(List<QueryResult> queryResults) throws SQLException {
        for (QueryResult each : queryResults) {
            OrderByValue orderByValue = new OrderByValue(each, this.orderByItems);
            if (!orderByValue.next()) continue;
            this.orderByValuesQueue.offer(orderByValue);
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.isEmpty() ? queryResults.get(0) : this.orderByValuesQueue.peek().getQueryResult());
    }

    @Override
    public boolean next() throws SQLException {
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        OrderByValue firstOrderByValue = this.orderByValuesQueue.poll();
        if (firstOrderByValue.next()) {
            this.orderByValuesQueue.offer(firstOrderByValue);
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.peek().getQueryResult());
        return true;
    }

    protected Queue<OrderByValue> getOrderByValuesQueue() {
        return this.orderByValuesQueue;
    }

    protected boolean isFirstNext() {
        return this.isFirstNext;
    }
}

