/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.oracle.clause;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;

public final class OracleForClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OracleForClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.FOR)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.OF)) {
            do {
                this.basicExpressionParser.parse(selectStatement);
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        }
        if (this.lexerEngine.equalAny(OracleKeyword.NOWAIT, OracleKeyword.WAIT)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(OracleKeyword.SKIP)) {
            this.lexerEngine.accept(OracleKeyword.LOCKED);
        }
    }
}

