/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause.SQLServerOffsetClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause.SQLServerTopClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause.facade.SQLServerSelectClauseParserFacade;
import io.shardingsphere.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class SQLServerSelectParser
extends AbstractSelectParser {
    private final SQLServerTopClauseParser topClauseParser;
    private final SQLServerOffsetClauseParser offsetClauseParser;

    public SQLServerSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        super(shardingRule, lexerEngine, new SQLServerSelectClauseParserFacade(shardingRule, lexerEngine), shardingTableMetaData);
        this.topClauseParser = new SQLServerTopClauseParser(lexerEngine);
        this.offsetClauseParser = new SQLServerOffsetClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseTop(selectStatement);
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseOrderBy(selectStatement);
        this.parseOffset(selectStatement);
        this.parseSelectRest();
    }

    private void parseTop(SelectStatement selectStatement) {
        this.topClauseParser.parse(selectStatement);
    }

    private void parseOffset(SelectStatement selectStatement) {
        this.offsetClauseParser.parse(selectStatement);
    }
}

