/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiRepeatUntilOp;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;

public class MultiRepeatWhilstOp<T>
extends AbstractMultiOperator<T, T>
implements Multi<T> {
    private final Predicate<T> predicate;
    private final long times;

    public MultiRepeatWhilstOp(Multi<T> upstream, Predicate<T> predicate) {
        super(upstream);
        this.predicate = predicate;
        this.times = Long.MAX_VALUE;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        ParameterValidation.nonNullNpe(downstream, "downstream");
        RepeatWhilstProcessor<? super T> processor = new RepeatWhilstProcessor<T>(this.upstream, downstream, this.times != Long.MAX_VALUE ? this.times - 1L : Long.MAX_VALUE, this.predicate);
        downstream.onSubscribe(processor);
        this.upstream.subscribe(processor);
    }

    static final class RepeatWhilstProcessor<T>
    extends MultiRepeatUntilOp.RepeatProcessor<T> {
        private boolean stop = false;

        public RepeatWhilstProcessor(Multi<? extends T> upstream, MultiSubscriber<? super T> downstream, long times, Predicate<T> predicate) {
            super(upstream, downstream, times, predicate);
        }

        @Override
        public void onItem(T t) {
            try {
                this.stop = !this.predicate.test(t);
            }
            catch (Throwable failure) {
                this.cancel();
                this.downstream.onError(failure);
                return;
            }
            ++this.emitted;
            this.downstream.onNext(t);
        }

        @Override
        public void onCompletion() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L && !this.stop) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

