/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Supplier;

public class UniCreateFromDeferredSupplier<T>
extends AbstractUni<T> {
    private final Supplier<Uni<? extends T>> supplier;

    public UniCreateFromDeferredSupplier(Supplier<Uni<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        Uni<? extends T> uni;
        ParameterValidation.nonNull(subscriber, "subscriber");
        try {
            uni = this.supplier.get();
        }
        catch (Throwable e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
            return;
        }
        if (uni == null) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
        } else {
            AbstractUni.subscribe(uni, subscriber);
        }
    }
}

