package io.smallrye.reactive.messaging.kafka.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.AmbiguousResolutionException;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;

/**
 * Warning this class consists of generated code.
 */
public class KafkaExceptions_$bundle implements KafkaExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected KafkaExceptions_$bundle() {}
    public static final KafkaExceptions_$bundle INSTANCE = new KafkaExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalArgumentNoMetadata$str() {
        return "SRMSG18000: `message` does not contain metadata of class %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentNoMetadata(final Class c) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentNoMetadata$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalArgumentUnknownFailureStrategy$str() {
        return "SRMSG18001: Unknown failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateConsumeWithoutBackPressure$str() {
        return "SRMSG18002: Expecting downstream to consume without back-pressure";
    }
    @Override
    public final IllegalStateException illegalStateConsumeWithoutBackPressure() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateConsumeWithoutBackPressure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateOnlyOneSubscriber$str() {
        return "SRMSG18003: Only one subscriber allowed";
    }
    @Override
    public final IllegalStateException illegalStateOnlyOneSubscriber() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateOnlyOneSubscriber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidFailureStrategy$str() {
        return "SRMSG18004: Invalid failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownCommitStrategy$str() {
        return "SRMSG18005: Unknown commit strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownCommitStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownCommitStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidCommitStrategy$str() {
        return "SRMSG18006: Invalid commit strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidCommitStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidCommitStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindRebalanceListener2$str() {
        return "SRMSG18007: Unable to find the KafkaConsumerRebalanceListener named `%s` for channel `%s`";
    }
    @Override
    public final UnsatisfiedResolutionException unableToFindRebalanceListener(final String name, final String channel) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(String.format(getLoggingLocale(), unableToFindRebalanceListener2$str(), name, channel));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindRebalanceListener3$str() {
        return "SRMSG18008: Unable to select the KafkaConsumerRebalanceListener named `%s` for channel `%s` - too many matches (%d)";
    }
    @Override
    public final AmbiguousResolutionException unableToFindRebalanceListener(final String name, final String channel, final int count) {
        final AmbiguousResolutionException result = new AmbiguousResolutionException(String.format(getLoggingLocale(), unableToFindRebalanceListener3$str(), name, channel, count));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingValueDeserializer$str() {
        return "SRMSG18009: Cannot configure the Kafka consumer for channel `%s` - the `mp.messaging.incoming.%s.value.deserializer` property is missing";
    }
    @Override
    public final IllegalArgumentException missingValueDeserializer(final String channel, final String channelAgain) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingValueDeserializer$str(), channel, channelAgain));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateInstance$str() {
        return "SRMSG18010: Unable to create an instance of `%s`";
    }
    @Override
    public final IllegalArgumentException unableToCreateInstance(final String clazz, final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToCreateInstance$str(), clazz), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindDeserializationFailureHandler2$str() {
        return "SRMSG18011: Unable to find the DeserializationFailureHandler named `%s` for channel `%s`";
    }
    @Override
    public final UnsatisfiedResolutionException unableToFindDeserializationFailureHandler(final String name, final String channel) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(String.format(getLoggingLocale(), unableToFindDeserializationFailureHandler2$str(), name, channel));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindDeserializationFailureHandler3$str() {
        return "SRMSG18012: Unable to select the DeserializationFailureHandler named `%s` for channel `%s` - too many matches (%d)";
    }
    @Override
    public final AmbiguousResolutionException unableToFindDeserializationFailureHandler(final String name, final String channel, final int count) {
        final AmbiguousResolutionException result = new AmbiguousResolutionException(String.format(getLoggingLocale(), unableToFindDeserializationFailureHandler3$str(), name, channel, count));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingValueSerializer$str() {
        return "SRMSG18013: Cannot configure the Kafka producer for channel `%s` - the `mp.messaging.outgoing.%s.value.serializer` property is missing";
    }
    @Override
    public final IllegalArgumentException missingValueSerializer(final String channel, final String channelAgain) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingValueSerializer$str(), channel, channelAgain));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingProperty$str() {
        return "SRMSG18014: The config property '%s' is required but it could not be found in any config source";
    }
    @Override
    public final NoSuchElementException missingProperty(final String propertyName) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), missingProperty$str(), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertProperty$str() {
        return "SRMSG18015: Cannot convert property '%s' of type %s to %s";
    }
    @Override
    public final NoSuchElementException cannotConvertProperty(final String propertyName, final Class<?> type, final Class<?> targetType) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), cannotConvertProperty$str(), propertyName, type, targetType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindSerializationFailureHandler2$str() {
        return "SRMSG18016: Unable to find the SerializationFailureHandler named `%s` for channel `%s`";
    }
    @Override
    public final UnsatisfiedResolutionException unableToFindSerializationFailureHandler(final String name, final String channel) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(String.format(getLoggingLocale(), unableToFindSerializationFailureHandler2$str(), name, channel));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindSerializationFailureHandler3$str() {
        return "SRMSG18017: Unable to select the SerializationFailureHandler named `%s` for channel `%s` - too many matches (%d)";
    }
    @Override
    public final AmbiguousResolutionException unableToFindSerializationFailureHandler(final String name, final String channel, final int count) {
        final AmbiguousResolutionException result = new AmbiguousResolutionException(String.format(getLoggingLocale(), unableToFindSerializationFailureHandler3$str(), name, channel, count));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
