/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.UnionQNameTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicateLambda;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSet;

public class NameTestUnion
extends NodeTest
implements QNameTest {
    private final UnionQNameTest nameTest;
    private final int nodeKind;

    public NameTestUnion(UnionQNameTest nameTest, int nodeKind) {
        assert (nodeKind == 1 || nodeKind == 2);
        this.nameTest = nameTest;
        this.nodeKind = nodeKind;
    }

    public static NameTestUnion withTests(List<NodeTest> tests) {
        assert (!tests.isEmpty());
        int nodeKind = tests.get(0).getPrimitiveType();
        assert (nodeKind == 1 || nodeKind == 2);
        ArrayList<QNameTest> qNameTests = new ArrayList<QNameTest>(tests.size());
        for (NodeTest test : tests) {
            if (test instanceof QNameTest) {
                qNameTests.add((QNameTest)((Object)test));
                continue;
            }
            assert (false);
        }
        return new NameTestUnion(new UnionQNameTest(qNameTests), nodeKind);
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public UType getUType() {
        return this.nodeKind == 1 ? UType.ELEMENT : UType.ATTRIBUTE;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return nodeKind == this.nodeKind && this.nameTest.matches(name.getStructuredQName());
    }

    @Override
    public IntPredicateProxy getMatcher(NodeVectorTree tree) {
        byte[] nodeKindArray = tree.getNodeKindArray();
        int[] nameCodeArray = tree.getNameCodeArray();
        NamePool pool = tree.getNamePool();
        return IntPredicateLambda.of(nodeNr -> (nodeKindArray[nodeNr] & 0xF) == this.nodeKind && this.nameTest.matchesFingerprint(pool, nameCodeArray[nodeNr] & 0xFFFFF));
    }

    @Override
    public boolean test(NodeInfo node) {
        return this.matches(node.getNodeKind(), NameOfNode.makeName(node), node.getSchemaType());
    }

    @Override
    public boolean matches(StructuredQName qname) {
        return this.nameTest.matches(qname);
    }

    @Override
    public boolean matchesFingerprint(NamePool namePool, int fp) {
        return this.nameTest.matchesFingerprint(namePool, fp);
    }

    @Override
    public final double getDefaultPriority() {
        return 1.0;
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public StructuredQName getMatchingNodeName() {
        return null;
    }

    @Override
    public int getPrimitiveType() {
        return this.nodeKind;
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.empty();
    }

    public String toString() {
        switch (this.nodeKind) {
            case 1: {
                return "element(" + this.nameTest.toString() + ")";
            }
            case 2: {
                return "attribute(" + this.nameTest.toString() + ")";
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        return this.nodeKind << 21 ^ this.nameTest.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof NameTestUnion && ((NameTestUnion)other).nodeKind == this.nodeKind && ((NameTestUnion)other).nameTest.equals(this.nameTest);
    }

    @Override
    public String getFullAlphaCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String exportQNameTest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        Optional<String> explanation = super.explainMismatch(item, th);
        if (explanation.isPresent()) {
            return explanation;
        }
        return Optional.of("The node has the wrong name");
    }

    @Override
    public String toShortString() {
        return this.toString();
    }
}

