/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.FileLog;
import ca.uhn.hl7v2.LogException;

public abstract class Log {
    private static Log log;

    public static synchronized Log getInstance() throws LogException {
        if (log == null) {
            String logClass = System.getProperty("ca.on.uhn.hl7.log");
            if (logClass == null) {
                log = new FileLog();
            } else {
                try {
                    log = (Log)Class.forName(logClass).newInstance();
                }
                catch (ClassNotFoundException ce) {
                    throw new LogException("Can't initialize HL7 Log - can't find the Log subclass " + logClass + ".");
                }
                catch (ClassCastException cce) {
                    throw new LogException("Can't initialize HL7 Log - the specified log class - " + logClass + " - does not extend ca.on.uhn.hl7.Log");
                }
                catch (Exception e) {
                    throw new LogException("Can't initialize HL7 log of class " + logClass + ": " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        return log;
    }

    public static void tryToLog(Exception e, String message) {
        try {
            Log.getInstance().log(e, message);
        }
        catch (Exception loge) {
            loge.printStackTrace();
            System.err.println("\r\n\r\n------------------\r\nCan't write to exception log - writing to standard out ..." + message);
            e.printStackTrace();
            System.err.println("-----------------\r\n\r\n");
        }
    }

    public abstract void log(Exception var1, String var2) throws LogException;

    public abstract void log(String var1) throws LogException;

    public abstract String getDescription();

    public static void main(String[] args) {
        try {
            throw new LogException("this is a test message");
        }
        catch (Exception e) {
            try {
                Log.getInstance().log(e, "thing message");
            }
            catch (LogException le) {
                e.printStackTrace();
            }
            try {
                throw new LogException("this is a test message");
            }
            catch (Exception e2) {
                try {
                    Log.getInstance().log(e2, "");
                }
                catch (LogException le) {
                    e2.printStackTrace();
                }
                try {
                    throw new LogException("this is a test message");
                }
                catch (Exception e3) {
                    try {
                        Log.getInstance().log(e3, "");
                    }
                    catch (LogException le) {
                        e3.printStackTrace();
                    }
                    try {
                        Log.getInstance().log("status 1");
                    }
                    catch (Exception e4) {
                        e4.printStackTrace();
                    }
                    try {
                        Log.getInstance().log("status 2");
                    }
                    catch (Exception e5) {
                        e5.printStackTrace();
                    }
                    return;
                }
            }
        }
    }
}

