/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionDialog;
import ca.uhn.hl7v2.app.ConnectionListener;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.app.MessageTypeRouter;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.app.TwoPortService;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.view.TreePanel;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class TestPanel
extends JPanel
implements ConnectionListener {
    private static final HapiLog log = HapiLogFactory.getHapiLog(TestPanel.class);
    private PipeParser pparser = new PipeParser();
    private GenericParser parser = new GenericParser();
    private JTextArea outboundText;
    private TreePanel outboundTree;
    private JTextArea inboundText;
    private TreePanel inboundTree;
    private JTextArea hostTA;
    private JTextArea portTA;
    private Initiator conn = null;
    private Vector connections = new Vector();
    private JSplitPane messages;
    private JList connList = null;
    private MessageTypeRouter router = new MessageTypeRouter();
    private JCheckBox xmlCheckBox;

    public TestPanel() throws HL7Exception {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.outboundText = new JTextArea(10, 10);
        JScrollPane outTextScroll = new JScrollPane(this.outboundText);
        this.outboundTree = new TreePanel(this.pparser);
        JScrollPane outTreeScroll = new JScrollPane(this.outboundTree);
        this.inboundText = new JTextArea(10, 10);
        JScrollPane inTextScroll = new JScrollPane(this.inboundText);
        this.inboundTree = new TreePanel(this.pparser);
        JScrollPane inTreeScroll = new JScrollPane(this.inboundTree);
        JSplitPane outbound = new JSplitPane(1, true, TestPanel.addTitle(outTextScroll, " Outbound Message Text "), TestPanel.addTitle(outTreeScroll, " Outbound Message Tree "));
        JSplitPane inbound = new JSplitPane(1, true, TestPanel.addTitle(inTextScroll, " Inbound Message Text "), TestPanel.addTitle(inTreeScroll, " Inbound Message Tree "));
        this.messages = new JSplitPane(0, true, outbound, inbound);
        this.add((Component)this.messages, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        JButton parseButton = new JButton(" Parse ");
        JButton sendButton = new JButton(" Send ");
        JButton encodeButton = new JButton(" Encode Inbound ");
        JButton encodeOriginalButton = new JButton(" Encode Outbound ");
        this.xmlCheckBox = new JCheckBox("Use XML", false);
        JButton connectButton = new JButton(" Connect ");
        JButton disconnectButton = new JButton(" Disconnect ");
        this.hostTA = new JTextArea(1, 30);
        this.portTA = new JTextArea(1, 6);
        controlPanel.add(parseButton);
        controlPanel.add(sendButton);
        controlPanel.add(encodeButton);
        controlPanel.add(encodeOriginalButton);
        controlPanel.add(this.xmlCheckBox);
        controlPanel.add(connectButton);
        controlPanel.add(disconnectButton);
        this.add((Component)controlPanel, "North");
        this.connList = new JList();
        this.connList.setPrototypeCellValue("xxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.connList.setSelectionMode(0);
        JPanel connPanel = new JPanel(new BorderLayout());
        connPanel.add((Component)new JScrollPane(this.connList), "Center");
        connPanel.add((Component)new JLabel(" Connections "), "North");
        this.add((Component)connPanel, "East");
        parseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.parseOutbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    new ConnectionDialog(TestPanel.this.getThis());
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.sendAndRecieve();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        encodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.encodeInbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        encodeOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.encodeOutbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        this.xmlCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (TestPanel.this.xmlCheckBox.isSelected()) {
                    TestPanel.this.parser.setXMLParserAsPrimary();
                } else {
                    TestPanel.this.parser.setPipeParserAsPrimary();
                }
            }
        });
        disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.disconnect(TestPanel.this.getCurrentConnection());
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
    }

    private TestPanel getThis() {
        return this;
    }

    protected Parser getParser() {
        return this.parser;
    }

    private static JPanel addTitle(Component toBeTitled, String title) {
        JPanel newPanel = new JPanel(new BorderLayout());
        newPanel.add(toBeTitled, "Center");
        newPanel.add((Component)new JLabel(title), "North");
        return newPanel;
    }

    public void showException(Exception e) {
        JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        log.error("showException: ", e);
    }

    public void parseOutbound() throws HL7Exception, EncodingNotSupportedException {
        String messageString = this.outboundText.getText().replace('\n', '\r');
        Message out = this.parser.parse(messageString);
        this.outboundTree.setMessage(out);
        if (this.messages.getDividerLocation() < 0) {
            this.messages.setDividerLocation(0.5);
        }
        this.validate();
    }

    private Connection getCurrentConnection() {
        Connection conn = null;
        Object o = this.connList.getSelectedValue();
        if (o != null) {
            conn = (Connection)o;
        }
        return conn;
    }

    public void connect(String host, int port) throws IOException, LLPException {
        Socket s = new Socket(host, port);
        this.addConnection(new Connection(this.parser, LowerLayerProtocol.makeLLP(), s));
    }

    public void connect(String host, int inboundPort, int outboundPort) throws IOException, LLPException {
        Socket in = new Socket(host, inboundPort);
        Socket out = new Socket(host, outboundPort);
        this.addConnection(new Connection(this.parser, LowerLayerProtocol.makeLLP(), in, out));
    }

    public void connectionReceived(Connection connection) {
        this.addConnection(connection);
    }

    public void connectionDiscarded(Connection connection) {
        this.connections.remove(connection);
        this.connList.setListData(this.connections);
    }

    private void addConnection(Connection c) {
        c.getResponder().registerApplication(this.router);
        this.connections.add(c);
        this.connList.setListData(this.connections);
    }

    private void disconnect(Connection c) {
        if (c != null) {
            c.close();
            this.connections.remove(c);
            this.connList.setListData(this.connections);
        }
    }

    public MessageTypeRouter getRouter() {
        return this.router;
    }

    public void sendAndRecieve() throws HL7Exception, LLPException, IOException {
        Message inbound;
        Message outbound = this.outboundTree.getMessage();
        try {
            inbound = this.getCurrentConnection().getInitiator().sendAndReceive(outbound);
        }
        catch (NullPointerException e) {
            throw new IOException("Please select a Connection.");
        }
        this.inboundTree.setMessage(inbound);
        this.validate();
    }

    public void encodeInbound() throws HL7Exception {
        String inbound = this.parser.encode(this.inboundTree.getMessage());
        inbound = inbound.replace('\r', '\n');
        this.inboundText.setText(inbound);
    }

    public void encodeOutbound() throws HL7Exception {
        String outbound = this.parser.encode(this.outboundTree.getMessage());
        outbound = outbound.replace('\r', '\n');
        TestPanel.openTextWindow("Outbound Message", outbound);
    }

    public static void openTextWindow(String title, String text) {
        JFrame frame = new JFrame(title);
        try {
            frame.getContentPane().setLayout(new BorderLayout());
            JTextArea textArea = new JTextArea(text);
            JScrollPane scroll = new JScrollPane(textArea);
            frame.getContentPane().add((Component)scroll, "Center");
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.err.println("Can't display text in new window: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length > 2) {
            System.out.println("Usage: ca.uhn.hl7v2.app.TestPanel [inbound_port [outbound_port] ]");
            System.out.println("    If port numbers are provided, an HL7Server will be started, to listen for incoming connections.");
            System.out.println("    If outbound port is not provided, inbound and outbound messages will use the same port.");
            System.exit(1);
        }
        JFrame frame = new JFrame("Message Tester");
        try {
            TestPanel panel = new TestPanel();
            try {
                if (args.length > 0) {
                    HL7Service service = null;
                    GenericParser parser = new GenericParser();
                    LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
                    int inPort = Integer.parseInt(args[0]);
                    if (args.length > 1) {
                        int outPort = Integer.parseInt(args[1]);
                        service = new TwoPortService(panel.getParser(), llp, inPort, outPort);
                    } else {
                        service = new SimpleServer(inPort, llp, panel.getParser());
                    }
                    service.registerConnectionListener(panel);
                    service.start();
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("The given port number(s) are not valid integers");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            frame.getContentPane().add((Component)panel, "Center");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ConnectionLabel
    extends JLabel {
        private Connection conn;

        public ConnectionLabel(Connection c) {
            super("Connection: " + c.toString());
            this.conn = c;
        }

        public Connection getConnection() {
            return this.conn;
        }
    }
}

